<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderStatusFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\PaymentMethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\EmailTemplateManager;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\OrderManager;
use Svenbluege\Component\Eventgallery\Site\Library\Order;
use Svenbluege\Component\Eventgallery\Site\Library\OrderStatus;

defined('_JEXEC') or die;

class CheckoutController extends \Joomla\CMS\MVC\Controller\BaseController
{
    public function display($cachable = false, $urlparams = array())
    {
        $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        $useAddressDataFromUser = $config->getCheckout()->doUseAddressDataFromUser();

        $user = Factory::getUser();

        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cart = $cartMgr->getCart();
        if ($useAddressDataFromUser) {
            if ($cart->getShippingMethod() != null && $cart->getShippingMethod()->needsAddressData()) {
                $cartMgr->setAddressFromUser($cart, $user, false);
            }
        }

        parent::display(false, $urlparams);
    }

    /**
     * @param Order $order
     *
     * @return mixed|string
     */
    protected  function _sendOrderConfirmationMail($order, $show_vat, $disclaimer) {
        /**
         * @var EmailTemplateManager $emailtemplateMgr
         */
        $emailtemplateMgr = EmailTemplateManager::getInstance();

        $data = Array();

        $data['disclaimer'] = $disclaimer;
        $data['order'] = $emailtemplateMgr->createOrderData($order, $show_vat);

        $data = json_decode(json_encode($data), FALSE);

        $to = Array($order->getEMail(), $order->getBillingAddress()==null? "": $order->getBillingAddress()->getFirstName().' '.$order->getBillingAddress()->getLastName());
        return $emailtemplateMgr->sendMail('new_order', $order->getLanguage(), true, $data, $to, true);

    }

    /**
     * just sets the layout for the confirm page
     *
     * @param bool  $cachable
     * @param array $urlparams
     */
    public function confirm($cachable = false, $urlparams = array())
    {
        $this->input->set('layout', 'confirm');
        $this->display($cachable, $urlparams);
    }

    /**
     * Just sets the layout for the change page
     *
     * @param bool  $cachable
     * @param array $urlparams
     */
    public function change($cachable = false, $urlparams = array())
    {
        $this->input->set('layout', 'change');

        $this->display($cachable, $urlparams);
    }

    public function saveChanges($cachable = false, $urlparams = array())
    {
        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();

        Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
        $errors = array();
        $errors = array_merge($errors, $cartMgr->updateShippingMethod());
        $errors = array_merge($errors, $cartMgr->updatePaymentMethod());

        // if we have a shipping method which does not need an address, we can skip the address form processing. Still we need
        // to handle name, phone and message.
        if ($cartMgr->getCart()->getShippingMethod() != null && !$cartMgr->getCart()->getShippingMethod()->needsAddressData()) {
            $errors = array_merge($errors, $cartMgr->updateAddresses(null, true));
        } else {
            $errors = array_merge($errors, $cartMgr->updateAddresses(null, false));
        }
        $cartMgr->calculateCart();

        if (count($errors) > 0) {
            $msg = "";
            $app = Factory::getApplication();

            /**
             * @var Exception $error
             */
            foreach ($errors as $error) {
                $this->setMessage($msg);
                $app->enqueueMessage($error->getMessage(), 'error');
            }

            $this->change($cachable, $urlparams);
        } else {
            $continue = $this->input->getString('continue', null);

            $msg = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CHANGES_STORED');
            if ($continue == null) {
                $this->setRedirect(
                     Route::_("index.php?option=com_eventgallery&view=checkout&task=change"), $msg, 'info'
                );
            } else {
                $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=checkout"));
            }
        }
    }


    public function createOrder()
    {
        Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));

        $app = Factory::getApplication();
        $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        // Check for request forgeries.

        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cartMgr->calculateCart();
        $cart = $cartMgr->getCart();

        // switch to the change page.
        $continue = $this->input->getString('continue', null);

        $newsletter_optin = $this->input->getBool('newsletter_optin', 0);
        $cart->setNewsletterOptIn($newsletter_optin);


        if ($continue == null) {
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=checkout&task=change"));
            return;
        }

        // if the cart is empty
        if ($cart->getLineItemsCount()==0) {
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=cart"));
            return;
        }

        /** create order
        * @var OrderManager $orderMgr
        */
        $orderMgr = OrderManager::getInstance();

        if (!$cart->getPaymentMethod()->verfiyPaymentMethodServiceLineItem($cart)) {
            $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_PAYMENT_VERIFICATION_FAILED'), 'error');
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=checkout"));
            return;
        }

        #$order = $cart;
        $order = $orderMgr->createOrder($cart);

        /* send mail */
        if ($order->getPaymentMethod()->doSendOrderConfirmationMailOnlyOnPaymentComplete() === false) {
            $disclaimerObject = new Localizablestring($config->getCheckout()->getCheckoutDisclaimer());
            $disclaimer = !empty($disclaimerObject->get())?$disclaimerObject->get():\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_ORDER_MAIL_CONFIRMATION_DISCLAIMER');
            $send = $this->_sendOrderConfirmationMail($order, $config->getCheckout()->doShowVat(), $disclaimer);

            if ($send !== true) {
                $msg = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_ORDER_FAILED') . ' (' . $send . ')';
            } else {
                $msg = NULL;
            }
        }

        $orderMgr->processOnOrderSubmit($order);

        if ($order->getTotal()->getAmount()<=0) {
            /**
             * @var OrderStatusFactory $orderstatusFactory
             */
            $orderstatusFactory = OrderStatusFactory::getInstance();
            $order->setPaymentStatus($orderstatusFactory->getOrderStatusById(OrderStatus::TYPE_PAYMENT_PAID));
        }

        if ($order->getPaymentMethod()->doRedirectToPaymentProvider() && $order->getTotal()->getAmount() > 0) {
            $this->setRedirect($order->getPaymentMethod()->getRedirectToPaymentProviderUrl($order));
        } else {
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=checkout&task=confirm"), $msg, 'info');
        }

    }

    public function processPayment() {
       $methodid = $this->input->getString("paymentmethodid",null);
        /**
         * @var PaymentMethodFactory $methodFactory
         */

        $methodFactory = PaymentMethodFactory::getInstance();
        $method = $methodFactory->getMethodById($methodid, false);
        if ($method != null) {
            $method->onIncomingExternalRequest();
        }


    }



}
