<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\FolderProtection;

defined('_JEXEC') or die;

class EventController extends \Joomla\CMS\MVC\Controller\BaseController
{
    public function display($cachable = false, $urlparams = array())
    {
        $password = $this->input->getString('password', '');
        $folder = $this->input->getString('folder', '');
        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        $folder = $folderFactory->getFolder($folder);


        // we need to do this only if someone entered a password.
        // the views will protect themselfs
        $accessAllowed = FolderProtection::isAccessAllowed($folder, $password);
        if (!empty($password) && !$accessAllowed) {
            $msg = Text::_('COM_EVENTGALLERY_PASSWORD_FORM_ERROR');
            $this->setRedirect( Route::_("index.php?option=com_eventgallery&view=password&folder=" . $folder->getFolderName(), false), $msg, 'error');
            $this->redirect();
        }

        if (!$accessAllowed) {
            $cachable = false;
        }

        parent::display($cachable, $urlparams);
    }

    public function resetViewCache() {
        parent::$views = null;
    }

}
