<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\GooglePhotosFile;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosFolder;

defined('_JEXEC') or die;

class GooglephotosapiController extends \Joomla\CMS\MVC\Controller\BaseController
{

    public function getAlbum()
    {
        header('Content-Type: application/json');
        $result = [];

        $foldername = $this->input->getString('folder', NULL);

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        $folder = $folderFactory->getFolder($foldername);
        if ($folder != null && $folder->isAccessible() && $folder->isVisible()) {
            /**
             * @var GooglePhotosFolder $folder
             */
            foreach($folder->getFilesForImages() as $file) {
                /**
                 * @var GooglePhotosFile $file
                 */

                $result[$file->getFileName()]  = $file->getBaseUrl();
            }
        }

        echo json_encode($result);
        $this->endExecution();
    }

    public function getAlbums()
    {
        header('Content-Type: application/json');
        $result = [];
        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        $allFolders = $folderFactory->getAllFolders();
        foreach ($allFolders as $folder) {
            /**
             * @var Folder $folder
             */
            if ($folder->getFolderType()->getId() != GooglePhotosFolder::ID) {
                continue;
            }

            /**
             * @var GooglePhotosFolder $folder
             */

            $files = $folder->getFilesForImages(0, 1, 1);
            if (count($files) == 0 ) {
                continue;
            }

            /**
             * @var GooglePhotosFile $file
             */
            $file = $files[0];

            $result[$folder->getFolderName()] = [$file->getFileName() => $file->getBaseUrl()];

        }

        echo json_encode($result);
        $this->endExecution();
    }

    public function endExecution() {
        die();
    }


}
