<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;

defined('_JEXEC') or die;

class RestController extends \Joomla\CMS\MVC\Controller\BaseController
{
    /**
     * adds an item to the cart
     */
    public function add2cart()
    {

        $file = $this->input->getString('file', NULL);
        $folder = $this->input->getString('folder', NULL);
        $quantity = $this->input->getString('quantity', 1);
        $imagetypeid = $this->input->getString('imagetypeid', NULL);

        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cart = $cartMgr->getCart();
        if (!empty($folder) && !empty($file)) {
            $cart->addItem($folder, $file, $quantity, $imagetypeid, true, false);
        }
        $cartMgr->calculateCart();

        Factory::getApplication()->getDocument()->setMimeEncoding('application/json');
        $this->printCartJSON($cart);

    }

    /* returns the cart */

    /**
     * @param $cart - the cart object
     */
    protected function printCartJSON($cart)
    {

        $jsonCart = array();
        if (isset($cart)) {
            foreach ($cart->getLineItems() as $lineitem) {
                /* @var $lineitem ImageLineitem */
                $item = array(
                    'file' => $lineitem->getFileName(),
                    'folder' => $lineitem->getFolderName(),
                    'count' => $lineitem->getQuantity(),
                    'singleprice' => $lineitem->getSinglePrice(),
                    'price' => $lineitem->getPrice()->getAmount(),
                    'lineitemid' => $lineitem->getId(),
                    'typeid' => $lineitem->getImageType()->getId(),
                    'imagetag' => $lineitem->getMiniCartThumb()
                );

                array_push($jsonCart, $item);
            }
        }

        Factory::getApplication()->getDocument()->setMimeEncoding('application/json');
        echo json_encode($jsonCart);
    }

    public function getCart()
    {
        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $cart = $cartMgr->getCart();
        Factory::getApplication()->getDocument()->setMimeEncoding('application/json');
        $this->printCartJSON($cart);
    }

    /**
     * removes an item from the cart
     */
    public function removeFromCart()
    {


        $lineitemid = $this->input->getString('lineitemid', NULL);
        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();

        $cart = $cartMgr->getCart();
        $cart->deleteLineItem($lineitemid);
        $cartMgr->calculateCart();
        Factory::getApplication()->getDocument()->setMimeEncoding('application/json');
        $this->printCartJSON($cart);
    }

}
