<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Access\Access;
use Joomla\CMS\Factory;
use Joomla\CMS\Mail\MailHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Table\Table;
use Joomla\CMS\User\User;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;

defined('_JEXEC') or die;

class SingleimageController extends \Joomla\CMS\MVC\Controller\BaseController
{

    public function display($cachable = false, $urlparams = array())
    {
        $folder = $this->input->getString('folder', '');

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        $folder = $folderFactory->getFolder($folder);


        if ($folder == null) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_NO_PUBLISHED_MESSAGE'), 404);
        }
        // we need to do this only if someone entered a password.
        // the views will protect themselfs
        $accessAllowed = $folder->isVisible();

        if (!$accessAllowed) {
            $cachable = false;
        }



        $viewLayout = $this->input->get('layout', 'default', 'string');

        if ('imagesetselection' == $viewLayout) {
            $cachable = false;
        }

        parent::display($cachable, $urlparams);
    }

    function saveReport($cachable = false, $urlparams = array()) {

        Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));

        $app = Factory::getApplication();

        $model = $this->getModel('Singleimage', '');

        $form = $model->getMessageForm();

        $data = $this->input->post->getArray();
        $validationSuccessful = $model->validate($form, $data);

        if ($validationSuccessful) {

            $row = Factory::getApplication()->bootComponent('com_eventgallery')->getMVCFactory()->createTable('Message', 'Administrator');
            $row->bind($app->input->post->getArray());
            $result = $row->store();

            /**
             * @var Joomla\Registry\Registry $config
             * @var Joomla\Registry\Registry $params
             */
            $config = Factory::getConfig();
            $mailer = Factory::getMailer();
            $egConfig = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();

            $subject = $config->get('sitename') . ' // ' . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_MESSAGES_REPORT_MAIL_SUBJECT');
            $body = [];
            $body[] = "<b>" . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_MESSAGES_EMAIL_LABEL') . ": </b> {$row->email}<br>";
            $body[] = "<b>" . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_MESSAGES_MESSAGE_LABEL') . ": </b> {$row->message}<br>";
            $body[] = "<b>Folder: </b> {$row->folder}<br>";
            $body[] = "<b>File: </b> {$row->file}<br>";
            $body = implode("", $body);

            $mailer->setSubject(
                $subject
            );

            $mailer->isHtml(true);
            $mailer->Encoding = 'base64';
            $mailer->setBody($body);

            // Customer Mail
            $sender = array(
                $config->get('mailfrom'),
                $config->get('fromname'));

            $mailer->setSender($sender);

            $userids = Access::getUsersByGroup($egConfig->getGeneral()->getAdminUserGroupId());

            foreach ($userids as $userid) {
                $user = User::getInstance($userid);
                if ($user->sendEmail == 1) {
                    $mailadresse = MailHelper::cleanAddress($user->email);
                    $mailer->addRecipient($mailadresse);
                }
            }

            $send = $mailer->Send();

            if ($result && $send) {
                $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_MESSAGES_REPORT_SAVE_SUCCESS'), 'info');
            } else {
                $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_MESSAGES_REPORT_SAVE_FAILED'), 'error');
            }

            $folder = $app->input->getString('folder');
            $file = $app->input->getString('file');
            $app->redirect( Route::_("index.php?option=com_eventgallery&view=singleimage&layout=report&folder=" . $folder . "&file=" . $file));
        }

        return $this->display($cachable, $urlparams);
    }

    public function resetViewCache() {
        parent::$views = null;
    }

}
