<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Controller;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Input\Input;
use Svenbluege\Component\Eventgallery\Site\Library\Exception\UnsupportedFileExtensionException;
use Svenbluege\Component\Eventgallery\Site\Model\UploadModel;

defined('_JEXEC') or die;

class UploadController extends \Joomla\CMS\MVC\Controller\BaseController
{

    public function __construct($config = array(), MVCFactoryInterface $factory = null, ?CMSApplication $app = null, ?Input $input = null)
    {
        $language = Factory::getLanguage();
        $extension = 'com_eventgallery';
        $language_tag = $language->getTag(); // loads the current language-tag
        $base_dir = JPATH_ADMINISTRATOR;
        $language->load($extension, $base_dir, $language_tag, true);
        $base_dir = JPATH_COMPONENT_ADMINISTRATOR;
        $language->load($extension, $base_dir, $language_tag, true);

        parent::__construct($config, $factory, $app, $input);
    }

    function upload() {
        $folder = $this->input->getString('folder');
        $doResizeUploadedFile = $this->input->getString('doresize', false) == 'true';
        try {
            $this->getModel()->upload($folder, $doResizeUploadedFile);
        } catch (UnsupportedFileExtensionException $e) {
            echo "Unsupported file extension";
        }
        die();
    }

}
