<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Dispatcher;
use Joomla\CMS\Dispatcher\ComponentDispatcher;
use Joomla\Http\Response;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\MediaLoader;

defined('_JEXEC') or die;

class Dispatcher extends ComponentDispatcher {
    /**
     * The default controller (and view), if none is specified in the request.
     *
     * @var   string
     */
    protected $defaultController = 'events';

    /** @inheritdoc */
    public function dispatch()
    {
        MediaLoader::loadMedia();
        $this->applyViewAndController();
        try {
            parent::dispatch();
        } catch (\InvalidArgumentException $e) {
            throw new \Exception($e->getMessage(), 404);
        }
    }

    /**
     * Applies the view and controller to the input object communicated to the MVC objects.
     *
     * If we have a controller without view or just a task=controllerName.taskName we populate the view to make things
     * easier and more consistent for us to handle.
     *
     * @return  void
     */
    protected function applyViewAndController(): void
    {
        $controller = $this->input->getCmd('controller', null);
        $view       = $this->input->getCmd('view', null);
        $task       = $this->input->getCmd('task', 'default');

        if (strpos($task, '.') !== false)
        {
            // Explode the controller.task command.
            [$controller, $task] = explode('.', $task);
            $view = null;
        }

        if (empty($controller) && empty($view))
        {
            $controller = $this->defaultController;
            $view       = $this->defaultController;
        }
        elseif (empty($controller) && !empty($view))
        {
            $controller = $view;
        }
        elseif (!empty($controller) && empty($view))
        {
            $view = $controller;
        }

        $controller = strtolower($controller);
        $view       = strtolower($view);


        $this->input->set('view', $view);
        $this->input->set('controller', $controller);
        $this->input->set('task', $task);
    }
}
