<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Helper;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
defined('_JEXEC') or die;

class CategoriesHelper
{

    public static function addCategoryPathToPathway($pathway, $rootCatId, $catId, $menuItemId, $skipRoot = false) {
        // add the category path

        if ( $catId != $rootCatId) {
            $options = Array();

            $categories = \Joomla\CMS\Categories\Categories::getInstance('Eventgallery', $options);
            // get the category and the path for the current folder

            $category = $categories->get($catId);

            if ($category != null) {
                $path = $category->getPath();


                // search the path for
                foreach ($path as $pathItem) {
                    $temp = explode(':', $pathItem);
                    $currentCatId = $temp[0];
                    $category = $categories->get($currentCatId);
                    if (!$skipRoot || $currentCatId != $rootCatId) {
                        $pathway->addItem(\Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryTitle($category),  Route::_('index.php?option=com_eventgallery&view=categories&catid=' . (int)$currentCatId . '&Itemid=' . $menuItemId));
                    }
                }
            }
        }
    }

    /**
     * @param JCategoryNode $category
     * @return String
     */
    public static function getCategoryTitle($category) {
        $params = $category->getParams();
        if (!$params->exists('eventgallery_title')) {
            return $category->title;
        }

        $lc = new Localizablestring($params->get('eventgallery_title'));

        $lcTitle = $lc->get();

        if (empty($lcTitle)) {
            return $category->title;
        }

        return $lcTitle;
    }

    /**
     * @param JCategoryNode $category
     * @return String
     */
    public static function getCategoryDescription($category) {
        $params = $category->getParams();
        if (!$params->exists('eventgallery_description')) {
            return $category->description;
        }

        $lc = new Localizablestring($params->get('eventgallery_description'));

        $lcDescription = $lc->get();

        if (empty($lcDescription)) {
            return $category->description;
        }

        return $lcDescription;
    }
}
