<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;

class Downloadlog
{
    const TYPE_DOWNLOAD_FULL = "download_full";
    const TYPE_DOWNLOAD_ORIGINAL = "download_original";
    const TYPE_PURCHASE_FILE = "purchase";

    public static $TYPES = [
        self::TYPE_DOWNLOAD_FULL => "COM_EVENTGALLERY_DOWNLOADLOG_TYPES_DOWNLOAD_FULL",
        self::TYPE_DOWNLOAD_ORIGINAL => "COM_EVENTGALLERY_DOWNLOADLOG_TYPES_DOWNLOAD_ORIGINAL",
        self::TYPE_PURCHASE_FILE => "COM_EVENTGALLERY_DOWNLOADLOG_TYPES_PURCHASE",
    ];

    public static function getTypeDisplayName($type) {
        if (!isset(self::$TYPES[$type])) {
            return $type;
        }
        return Text::_(self::$TYPES[$type]);
    }

}
