<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;

defined('_JEXEC') or die;

/**
 * Joomla! Formatted Text File Log class
 *
 * This class is designed to use as a base for building formatted text files for output. By
 * default it emulates the Syslog style format output. This is a disk based output format.
 *
 */

class FormattedTextLogger extends \Joomla\CMS\Log\Logger\FormattedtextLogger
{
    private $file;

    protected function initFile()
    {

        $logFilenameBase = str_replace('.php', '', $this->path);

        $logFile = $logFilenameBase.'.php';

        if(file_exists($logFile)) {
            if(@filesize($logFile) > 1048756) {
                $altLog = $logFilenameBase.'-'.time().'.php';
                File::copy($logFile, $altLog);
                File::delete($logFile);
            }
        }


        // If the file doesn't already exist we need to create it and generate the file header.
        if (!is_file($this->path))
        {

            // Make sure the folder exists in which to create the log file.
            Folder::create(dirname($this->path));

            // Build the log file header.
            $head = $this->generateFileHeader();
        }
        else
        {
            $head = false;

        }

        // Open the file for writing (append mode).
        if (!$this->file = fopen($this->path, 'a'))
        {
            throw new \RuntimeException('Cannot open file for writing log');
        }
        if ($head)
        {
            if (!fwrite($this->file, $head))
            {
                throw new \RuntimeException('Cannot fput file for log');
            }
        }
    }
}
