<?php
namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactory;
use Joomla\CMS\Table\Table;

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


defined('_JEXEC') or die();

class GeoObjects
{
    private static $states_published = null;
    private static $states = null;

    private static $countryCodes = array(
        '',
        'AD',
        'AE',
        'AF',
        'AG',
        'AI',
        'AL',
        'AM',
        'AO',
        'AQ',
        'AR',
        'AS',
        'AT',
        'AU',
        'AW',
        'AX',
        'AZ',
        'BA',
        'BB',
        'BD',
        'BE',
        'BF',
        'BG',
        'BH',
        'BI',
        'BJ',
        'BL',
        'BM',
        'BN',
        'BO',
        'BQ',
        'BR',
        'BS',
        'BT',
        'BV',
        'BW',
        'BY',
        'BZ',
        'CA',
        'CC',
        'CD',
        'CF',
        'CG',
        'CH',
        'CI',
        'CK',
        'CL',
        'CM',
        'CN',
        'CO',
        'CR',
        'CU',
        'CV',
        'CW',
        'CX',
        'CY',
        'CZ',
        'DE',
        'DJ',
        'DK',
        'DM',
        'DO',
        'DZ',
        'EC',
        'EE',
        'EG',
        'EH',
        'ER',
        'ES',
        'ET',
        'FI',
        'FJ',
        'FK',
        'FM',
        'FO',
        'FR',
        'GA',
        'GB',
        'GD',
        'GE',
        'GF',
        'GG',
        'GH',
        'GI',
        'GL',
        'GM',
        'GN',
        'GP',
        'GQ',
        'GR',
        'GS',
        'GT',
        'GU',
        'GW',
        'GY',
        'HK',
        'HM',
        'HN',
        'HR',
        'HT',
        'HU',
        'ID',
        'IE',
        'IL',
        'IM',
        'IN',
        'IO',
        'IQ',
        'IR',
        'IS',
        'IT',
        'JE',
        'JM',
        'JO',
        'JP',
        'KE',
        'KG',
        'KH',
        'KI',
        'KM',
        'KN',
        'KP',
        'KR',
        'KW',
        'KY',
        'KZ',
        'LA',
        'LB',
        'LC',
        'LI',
        'LK',
        'LR',
        'LS',
        'LT',
        'LU',
        'LV',
        'LY',
        'MA',
        'MC',
        'MD',
        'ME',
        'MF',
        'MG',
        'MH',
        'MK',
        'ML',
        'MM',
        'MN',
        'MO',
        'MP',
        'MQ',
        'MR',
        'MS',
        'MT',
        'MU',
        'MV',
        'MW',
        'MX',
        'MY',
        'MZ',
        'NA',
        'NC',
        'NE',
        'NF',
        'NG',
        'NI',
        'NL',
        'NO',
        'NP',
        'NR',
        'NU',
        'NZ',
        'OM',
        'PA',
        'PE',
        'PF',
        'PG',
        'PH',
        'PK',
        'PL',
        'PM',
        'PN',
        'PR',
        'PS',
        'PT',
        'PW',
        'PY',
        'QA',
        'RE',
        'RO',
        'RS',
        'RU',
        'RW',
        'SA',
        'SB',
        'SC',
        'SD',
        'SE',
        'SG',
        'SH',
        'SI',
        'SJ',
        'SK',
        'SL',
        'SM',
        'SN',
        'SO',
        'SR',
        'SS',
        'ST',
        'SV',
        'SX',
        'SY',
        'SZ',
        'TC',
        'TD',
        'TF',
        'TG',
        'TH',
        'TJ',
        'TK',
        'TL',
        'TM',
        'TN',
        'TO',
        'TR',
        'TT',
        'TV',
        'TW',
        'TZ',
        'UA',
        'UG',
        'UM',
        'US',
        'UY',
        'UZ',
        'VA',
        'VC',
        'VE',
        'VG',
        'VI',
        'VN',
        'VU',
        'WF',
        'WS',
        'YE',
        'YT',
        'ZA',
        'ZM',
        'ZW',
    );

    public static function getCountries() {
        $countries = [];
        foreach (self::$countryCodes as $countryCode) {
            $countries[$countryCode] = self::getCountryName($countryCode);
        }
        asort($countries);
        return $countries;
    }

    public static function getCountryName($countrycode) {
        if (in_array($countrycode, self::$countryCodes) ){
            return Text::_('COM_EVENTGALLERY_COUNTRY_'.$countrycode);
        }

        return $countrycode;
    }

    public static function getStateName($stateCode) {
        $statesObjects = self::getStates();
        foreach($statesObjects as $country=>$states) {
            foreach($states as $state) {
                if ($state->statecode == $stateCode) {
                    return $state->statename;
                }
            }
        }
        return $stateCode;
    }

    public static function getStateID($stateCode) {
        return $stateCode;
    }

    /**
     * @return array returns an array country=>states Object
     */
    public static function getStates($publishedOnly = false) {
        if (self::$states != null) {
            if ($publishedOnly) {
                return self::$states_published;

            } else {
                return self::$states;
            }
        }


        $table = Factory::getApplication()->bootComponent('com_eventgallery')->getMVCFactory()->createTable('State', 'Administrator');
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')->from($table->getTableName())->order('ordering, statename');
        $db->setQuery($query);
        $result = $db->loadObjectList();

        self::$states = array();
        self::$states_published = array();

        foreach($result as $stateRow) {
            self::$states[$stateRow->countrycode][] = $stateRow;
            if ($stateRow->published==1) {
                self::$states_published[$stateRow->countrycode][] = $stateRow;
            }
        }

        if ($publishedOnly) {
            return self::$states_published;

        } else {
            return self::$states;
        }
    }
}
