<?php
namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class MediaHelper
{
    // copy from Joomla MediaHelper where this method is private
    public function getMimeType($file, $isImage = false)
    {
        // If we can't detect anything mime is false
        $mime = false;

        try
        {
            if ($isImage && function_exists('exif_imagetype'))
            {
                $mime = image_type_to_mime_type(exif_imagetype($file));
            }
            elseif ($isImage && function_exists('getimagesize'))
            {
                $imagesize = getimagesize($file);
                $mime      = isset($imagesize['mime']) ? $imagesize['mime'] : false;
            }
            elseif (function_exists('mime_content_type'))
            {
                // We have mime magic.
                $mime = mime_content_type($file);
            }
            elseif (function_exists('finfo_open'))
            {
                // We have fileinfo
                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                $mime  = finfo_file($finfo, $file);
                finfo_close($finfo);
            }
        }
        catch (\Exception $e)
        {
            // If we have any kind of error here => false;
            return false;
        }

        // If we can't detect the mime try it again
        if ($mime === 'application/octet-stream' && $isImage === true)
        {
            $mime = $this->getMimeType($file, false);
        }

        // We have a mime here
        return $mime;
    }

}
