<?php
namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;
use Joomla\Filesystem\Path;
use Joomla\CMS\Language\Text;
use Joomla\CMS\User\UserHelper;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\FolderProtection;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\MediaLoader;


/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

#[\AllowDynamicProperties]
abstract class ModuleDispatcher extends AbstractModuleDispatcher
{

    /**
     * @var string defines the cachegroup for the modules
     */
    protected $cachegroup = 'eventgallery_fixme';

    public function dispatch()
    {
        $this->loadLanguage();
        Factory::getApplication()->bootComponent('com_eventgallery');

         MediaLoader::loadLanguage($this->getApplication());
        MediaLoader::loadMedia();

        $displayData = $this->getLayoutData();

        // Abort when display data is false
        if ($displayData === false) {
            return;
        }

        $user = Factory::getUser();
        $displayData['usergroups'] = UserHelper::getUserGroups($user->id);
        $displayData['wrkaroundoptions'] = array('nopathway' => 1, 'nohead' => 0, 'nomodules' => 1, 'modulemode' => 1, 'mergehead' => 1);
        $displayData['wrkarounds'] = true;
        $displayData['id'] = false;
        $displayData['cachegroup'] = $this->cachegroup;
        $displayData['me'] = $this;


        // Execute the layout without the module context
        $loader = static function (array $displayData) {
            // If $displayData doesn't exist in extracted data, unset the variable.
            if (!\array_key_exists('displayData', $displayData)) {
                extract($displayData);
                unset($displayData);
            } else {
                extract($displayData);
            }

            $cache = Factory::getCache($cachegroup);
            $cache->setCaching($params->get('cache', 1) == 1);
            $cache->setLifeTime((int)$params->get('cache_time', 900));
            $cache->get(array($me,'uncachedRenderModule'), array($params, $module, $usergroups, FolderProtection::getUnlockedFoldersJSON()), $id, $wrkarounds, $wrkaroundoptions);
        };

        $loader($displayData);
    }


    /**
     * Execute this method to render a module within a class context without using the cache
     *
     * @param $params
     * @param $module
     * @param $usergroups
     * @param $unlockedFoldersJSONString a String which prevents caching issues. We always need to take the usergroups and the unlocked folders into accoutn
     * @return mixed
     */
    public abstract function uncachedRenderModule($params, $module, $usergroups, $unlockedFoldersJSONString);

    /**
     * @param $tpl
     * @return string
     * @throws \Exception
     */
    public function loadSnippet($tpl)
    {
        // Clear prior output
        $this->_output = null;


        $baseDir = JPATH_BASE . '/components/com_eventgallery/tmpl/snippets';
        $app = Factory::getApplication();
        $component = 'com_eventgallery';
        $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . 'snippets';

        $path = array($fallback, $baseDir);

        // Clean the file name
        $file = preg_replace('/[^A-Z0-9_\.-\/]/i', '', $tpl);
        $tpl = isset($tpl) ? preg_replace('/[^A-Z0-9_\.-]/i', '', $tpl) : $tpl;


        // Load the template script

        $filetofind = $this->_createFileName('file', array('name' => $file));
        $template = Path::find($path, $filetofind);

        // If alternate layout can't be found, fall back to default layout
        if ($template == false)
        {
            throw new \Exception(Text::sprintf('JLIB_APPLICATION_ERROR_LAYOUTFILE_NOT_FOUND', $file), 500);
        }


        // Unset so as not to introduce into template scope
        unset($tpl);
        unset($file);

        // Never allow a 'this' property
        if (isset($this->this))
        {
            unset($this->this);
        }

        // Start capturing output into a buffer
        ob_start();

        // Include the requested template filename in the local scope
        // (this will execute the view logic).
        include $template;

        // Done with the requested template; get the buffer and
        // clear it.
        $this->_output = ob_get_contents();
        ob_end_clean();

        return $this->_output;


    }

    /**
     * Create the filename for a resource
     *
     * @param   string  $type   The resource type to create the filename for
     * @param   array   $parts  An associative array of filename information
     *
     * @return  string  The filename
     */
    protected function _createFileName($type, $parts = array())
    {
        switch ($type)
        {
            case 'template':
                $filename = strtolower($parts['name']) . '.' . $this->_layoutExt;
                break;

            default:
                $filename = strtolower($parts['name']) . '.php';
                break;
        }

        return $filename;
    }

    /**
     * Method to escape output. Code-Copy from JLayoutBase
     *
     * @param   string  $output  The output to escape.
     *
     * @return  string  The escaped output.
     *
     * @since   3.0
     */

    public function escape($output)
    {
        return htmlspecialchars($output, ENT_COMPAT, 'UTF-8');
    }


}
