<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die();
/**
 * provides a money object which handled amount and currency.
 *
 * Class Money
 */
class Money
{

    protected $_amount;
    protected $_currency;
    protected $_currencyCode;

    /**
     * @param float $amount
     * @param string $currency
     */
    public function __construct($amount, $currency)
    {
        $this->_amount=(float)$amount;
        #$this->_currency=$currency;

        $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        $this->_currency = $config->getCheckout()->getCurrencySymbol();
        $this->_currencyCode = $config->getCheckout()->getCurrencyCode();
    }


    /**
     * @return string
     */
    public function __toString() {
        return Text::sprintf('COM_EVENTGALLERY_MONEY_FORMAT', $this->getCurrency(), $this->getFormattedAmount() );
    }


    /**
     * @return float
     */
    public function getAmount() {
        return $this->_amount;
    }

    /**
     * Returns the amount with the decimal separator and the thousands separator using the current locale
     *
     * @return string
     */
    public function getFormattedAmount() {
        $decimal_separator = Text::_('DECIMALS_SEPARATOR');
        $thousands_separator = Text::_('THOUSANDS_SEPARATOR');

        return number_format($this->getAmount(), 2, $decimal_separator, $thousands_separator);

    }

    /**
     * Returns the display name of the currency
     *
     * @return string
     */
    public function getCurrency() {
        return $this->_currency;
    }

    /**
     * Return the Currency Code like EUR or USD
     *
     * @return string
     */
    public function getCurrencyCode() {
        return $this->_currencyCode;
    }
}
