<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Common;
defined('_JEXEC') or die;


use Joomla\CMS\Categories\Categories;
use Joomla\CMS\Categories\CategoryNode;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Menu\MenuFactoryInterface;
use Joomla\Language\Language;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\Tags;

class RouteHelper
{
    /**
     * creates a link based on a category id
     * @param $catid
     * @param null $itemid
     * @throws Exception
     * @return string
     */
    public function createCategoryRoute($catid, $itemid = null) {

        if (empty($itemid)) {
            $menus = Factory::getContainer()->get(MenuFactoryInterface::class)->createMenu('site', []);

            /**
             * @var JLanguage $lang
             */
            $lang = \Joomla\CMS\Factory::getApplication()->getLanguage();

            $language = $lang->getTag();


            $component = ComponentHelper::getComponent('com_eventgallery');

            $attributes = array('component_id');
            $values = array($component->id);

            // take the current lang into account
            $attributes[] = 'language';
            $values[] = array($language, '*');


            $menuItems = $menus->getItems($attributes, $values);
            $itemid = NULL;
            $foundViewType = NULL;
            $options = array();
            $categories = Categories::getInstance('Eventgallery', $options);

            foreach ($menuItems as $menuItem) {
                if (isset($menuItem->query) && isset($menuItem->query['view'])) {
                    $view = $menuItem->query['view'];

                    if ($view == 'categories') {

                        // check the category reference
                        // the categories view uses the catid as query parameter, the events view as param
                        if (isset($menuItem->query['catid'])) {
                            $menuItemCatid = $menuItem->query['catid'];
                        } else {
                            $menuItemCatid = 0;
                        }
                        // if no category id is defined, this menu item would work
                        if ( null==$catid || $menuItemCatid  == 0 || $menuItemCatid == 'root') {
                            $itemMatches = true;
                        } else {

                            /**
                             * @var CategoryNode $category
                             */

                            // get the category and the path for the current folder
                            $category = $categories->get($catid);
                            $path = $category->getPath();
                            $categoryMatches = false;

                            // search the path for
                            foreach($path as $pathItem) {
                                $temp = explode(':', $pathItem);
                                $currentCatId = $temp[0];
                                if ($menuItemCatid == $currentCatId) {
                                    $categoryMatches = true;
                                    break;
                                }
                            }

                            $itemMatches = $categoryMatches;
                        }

                        // set the necessary parameters if the current item is valid
                        if ($itemMatches) {
                            $itemid = $menuItem->id;
                        }
                    }



                }

                if ($itemid != NULL) {
                    break;
                }
            }
        }


        $url = 'index.php?option=com_eventgallery&view=categories&catid='.$catid;

        // if not found, return language specific home link
        if ($itemid != NULL) {
            $url .= '&Itemid=' . $itemid;
        }

        return $url;
    }

    /**
     * create the route for a ucm link like from the tag component.
     *
     * @param $id
     * @param int $catid
     * @param int $language
     */
    public function getEventRoute($id, $catid = 0, $language = 0, $layout = null) {

        $temp = explode(':', $id);
        $id  = $temp[0];

        $db    = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('folder')
            ->from('#__eventgallery_folder')
            ->where('id=' . $db->quote($id));

        $db->setQuery($query);
        $row = $db->loadObject();

        return $this->createEventRoute($row->folder, null, null, null);
    }

    /**
     * creates a link to an event
     * @param $foldername
     * @param array $tags
     * @param $catid
     * @param null $itemid
     * @params String $targetLanguageCode
     * @throws Exception
     * @return string
     */
    public function createEventRoute($foldername, $tags, $catid, $itemid = null, $targetLanguageCode = null)
    {
        $foundViewType = NULL;

        if ($itemid == null) {
            $menuItem = $this->getMenuItemidForEvent($targetLanguageCode, $tags, $catid, $foldername, $itemid);
            if ($menuItem != null) {
                $itemid = $menuItem->id;
                $foundViewType = $menuItem->query['view'];
            }
        }

        $url = 'index.php?option=com_eventgallery&view=event&folder=' . $foldername;

        // if not found, return language specific home link
        if ($itemid != NULL) {
            // if this is an event view we don't need to specific additional data.
            if ($foundViewType == 'event') {
                return 'index.php?Itemid=' . $itemid;
            }

            if ($foundViewType == 'categories') {
                if (!empty($catid) && $catid != 0 && $catid != 'root') {
                    $url .= '&catid='.$catid;
                }
            }
            $url .= '&Itemid=' . $itemid;
        }

        return $url;
    }

    /**
     * @param $targetLanguageCode
     * @param array $tags
     * @param $catid
     * @param $foldername
     * @param $itemid
     * @return \Joomla\CMS\Menu\MenuItem
     */
    public function getMenuItemidForEvent($targetLanguageCode, $tags, $catid, $foldername, $itemid)
    {
        $menus = Factory::getContainer()->get(MenuFactoryInterface::class)->createMenu('site');
        /**
         * @var Language $lang
         */
        $lang = \Joomla\CMS\Factory::getApplication()->getLanguage();

        $language = $lang->getTag();

        if ($targetLanguageCode != null) {
            $language = $targetLanguageCode;
        }

        $component = ComponentHelper::getComponent('com_eventgallery');

        $attributes = array('component_id');
        $values = array($component->id);

        // take the current lang into account
        $attributes[] = 'language';
        $values[] = array($language, '*');

        $foundMenuItem = null;
        $items = $menus->getItems($attributes, $values);
        $itemid = NULL;
        $options = array();
        $categories = Categories::getInstance('Eventgallery', $options);

        foreach ($items as $item) {
            if (isset($item->query) && isset($item->query['view'])) {
                $view = $item->query['view'];

                if ($view == 'events' || $view == 'categories') {

                    // check the tags
                    if (count($item->getParams()->get('tags', array())) == 0) {
                        $itemMatches = true;
                    } else {
                        if (Tags::checkTags($item->getParams()->get('tags', array()), $tags)) {
                            $itemMatches = true;
                        } else {
                            $itemMatches = false;
                        }
                    }

                    // check the category reference
                    // the categories view uses the catid as query parameter, the events view as param
                    if ($view == 'categories' && isset($item->query['catid'])) {
                        $menuItemCatid = $item->query['catid'];
                    } else {
                        $menuItemCatid = $item->getParams()->get('catid', 0);
                    }
                    // if no category id is defined, this menu item would work
                    if (null == $catid || $menuItemCatid == 0 || $menuItemCatid == 'root') {
                        $itemMatches = $itemMatches && true;
                    } else {

                        /**
                         * @var CategoryNode $category
                         */

                        // get the category and the path for the current folder
                        $category = $categories->get($catid);
                        if ($category != null) {
                            $path = $category->getPath();
                            $categoryMatches = false;

                            // search the path for
                            foreach ($path as $pathItem) {
                                $temp = explode(':', $pathItem);
                                $currentCatId = $temp[0];
                                if ($menuItemCatid == $currentCatId) {
                                    $categoryMatches = true;
                                    break;
                                }
                            }

                            $itemMatches = $itemMatches && $categoryMatches;
                        }

                    }

                    // set the necessary parameters if the current item is valid
                    if ($itemMatches) {
                        $itemid = $item->id;
                        $foundViewType = $view;
                        $foundMenuItem = $item;
                    }
                }

                if ($view == 'event' && isset($item->query['folder']) && $item->query['folder'] == $foldername) {
                    $itemid = $item->id;
                    $foundViewType = $view;
                    $foundMenuItem = $item;
                }

            }

            if ($itemid != NULL) {
                break;
            }
        }
        return $foundMenuItem;
    }

    public function getCategoryRoute($catid, /** @noinspection PhpUnusedParameterInspection */$language = 0) {
        if ($catid instanceof CategoryNode)
        {
            $id = $catid->id;
            $category = $catid;
        }
        else
        {
            $id = (int) $catid;
            $categories = Categories::getInstance('Eventgallery');
            $category = $categories->get($id);
        }

        if ($id < 1 || !($category instanceof CategoryNode))
        {
            return '';
        }

        $link = \Svenbluege\Component\Eventgallery\Site\Library\Helper\Route::createCategoryRoute($id);

        return $link;
    }
}
