<?php

namespace Svenbluege\Component\Eventgallery\Site\Library\Common;

use FFMpeg\Coordinate\TimeCode;
use FFMpeg\FFMpeg;
use FFMpeg\FFProbe;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;

class Video
{
    /**
     * @param $path
     * @return Dimension
     */
    public static function getDimension($path) {
        try {
            $ffprobe = FFProbe::create([], new NullLogger());
            $dimensions = $ffprobe->streams($path)->first()->getDimensions();
            return new Dimension($dimensions->getWidth(), $height = $dimensions->getHeight());
        } catch (\Exception) {
            return new Dimension(1280, 786);
        }
    }

    /**
     * Extract an image from a video and save it to a given file.
     *
     * @param $file File
     * @param $image_file string
     * @param $target_file string
     * @return void
     */
    public static function extractImage($file, $image_file, $target_file) {
        try {
            $ffmpeg = FFMpeg::create([], new NullLogger());
            $video = $ffmpeg->open($image_file);
            $frame = $video->frame(TimeCode::fromSeconds(5));
            $frame->save($target_file);
        } catch (\Exception) {
            copy(JPATH_ROOT.DIRECTORY_SEPARATOR.COM_EVENTGALLERY_VIDEO_PLACEHOLDER_IMAGE, $target_file);
        }
    }
}
