<?php

namespace Svenbluege\Component\Eventgallery\Site\Library\Configuration;

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class Contentplugin extends Configuration
{
    public function getImageContentPluginImageWidth() {
        return (int)$this->get('image_content_plugin_image_width', 50);
    }

    public function getImageContentPluginImageCrop() {
        return $this->get('image_content_plugin_image_crop', 1) == 1;
    }

    public function getImageContentPluginMode() {
        return $this->get('image_content_plugin_image_mode', 'link');
    }

    public function getImageContentPluginCssClass() {
        return $this->get('image_content_plugin_cssclass', '');
    }

    public function getImageContentPluginUseCart() {
        return $this->get('image_content_plugin_use_cart', 0) == 1;
    }

    public function getImageContentPluginAttr() {
        return $this->get('image_content_plugin_attr', 'image');
    }

    public function getEventContentPluginAttr() {
        return $this->get('event_content_plugin_attr', 'images');
    }

    public function getEventContentPluginLinkMode() {
        return $this->get('event_content_plugin_link_mode', 'lightbox');
    }

    public function getEventContentPluginImageMode() {
        return $this->get('event_content_plugin_image_mode', 'thumbnails');
    }

    public function getEventContentPluginImageWidth() {
        return (int)$this->get('event_content_plugin_image_width', 50);
    }

    public function getEventContentPluginMaxImages() {
        return (int)$this->get('event_content_plugin_max_images', 5);
    }

    public function getEventContentPluginOffset() {
        return (int)$this->get('event_content_plugin_offset', 0);
    }

    public function getEventContentPluginUseCart() {
        return $this->get('event_content_plugin_use_cart', 0) == 1;
    }

    public function getEventContentPluginUseSlider() {
        return $this->get('event_content_plugin_use_slider', 0) == 1;
    }

    public function getEventContentPluginSliderRows() {
        return (int)$this->get('event_content_plugin_slider_rows', 1);
    }

    public function getEventContentPluginSliderAutoPlay() {
        return $this->get('event_content_plugin_slider_autoplay', 0) == 1;
    }

    public function getEventContentPluginSliderShownav() {
        return $this->get('event_content_plugin_slider_shownav', 0) == 1;
    }

}
