<?php

namespace Svenbluege\Component\Eventgallery\Site\Library\Configuration;

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector;

defined('_JEXEC') or die;

class General extends Configuration
{
    public function getAdminUserGroupId() {
        return $this->get('admin_usergroup', '8');
    }

    public function getFlickrAPIKey() {
        return $this->get('flickr_api_key', FlickrConnector::DEFAULT_FLICKR_API_KEY);
    }

    public function getDefaultUsergroup() {
        return $this->get('eventgallery_default_usergroup', [1]);
    }

    public function doShowUserGroupProtectedEventsInList() {
        return $this->get('show_usergroup_protected_events_in_list', 0) ==1;
    }

    public function doHideUserGroupProtectedEventsInList() {
        return !$this->doShowUserGroupProtectedEventsInList();
    }

    /**
     * @return integer
     */
    public function doLoadResponsiveCSS() {
        return intval($this->get('load_responsive_css', 1));
    }

    public function doUseCaching() {
        return $this->get('use_caching', 0) == 1;
    }

    public function doDebug() {
        return $this->get('debug', 0) == 1;
    }

    /**
     * @deprecated
     * @return mixed
     */
    public function getGooglePhotosRefreshToken() {
        return $this->get('google_photos_refresh_token', '');
    }

    public function getFlickrCacheLifetime() {
        return (int)$this->get('cache_flickr_lifetime',FlickrConnector::$cache_life);
    }

    public function isDownloadLogEnabled() {
        return $this->get('enable_downloadlog', 0) == 1;
    }

    public function getDefaultFolderTypeId() {
        return $this->get('default_folder_type_id', -1);
    }
}
