<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Database;

use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\Registry\Registry;

defined('_JEXEC') or die();

class DatabaseObject extends Registry
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * @param array  $data
     * @param string $table the Table name suffix
     *
     * @return bool|Table
     * @throws Exception
     */
    public function store($data, $table)
    {
        $app = Factory::getApplication();

        if ($data == null) {
            throw new \Exception("Can't store something without data for table table");
        }
        $data = $data ? $data : $app->input->post->getArray();
        if (isset($data['table'])) {
            throw new \Exception('Data should not contain table attribute for security reasons.');
        }

        /**
         * @var Table $row
         */
        $row = Table::getInstance($table, '');
        if (!$row) {
            $row = Table::getInstance($table.'Table', 'Svenbluege\\Component\\Eventgallery\\Administrator\\Table\\');
        }

        $date = date("Y-m-d H:i:s");

        if (isset($data['id'])) {
            $row->load($data['id']);
        }

        // Bind the form fields to the table
        if (!$row->bind($data)) {
            return false;
        }

        $row->modified = $date;

        if (!isset($row->created)) {
            $row->created = $date;
        }

        // Make sure the record is valid
        if (!$row->check()) {
            return false;
        }

        if (!$row->store()) {
            return false;
        }

        return $row;

    }


}
