<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseDriver;
use Svenbluege\Component\Eventgallery\Site\Library\Database\DatabaseObject;


defined('_JEXEC') or die();

/**
 * provides a base class for factories implementing the Singleton pattern.
 *
 * Class Factory
 *
 * @template T
 */
abstract class AbstractFactory extends DatabaseObject
{
    /**
     * @var array<class-string<T>, T>
     */
    private static $_instances = [];

    /**
     * @var DatabaseDriver
     */
    protected $db;

    public function __construct() {
        $this->db = Factory::getDbo();
        parent::__construct();
    }

    /**
     * @return T An instance of the specified class.
     */
    final public static function getInstance() {


        $calledClassName = get_called_class();

        if (! isset (self::$_instances[$calledClassName])) {
            self::$_instances[$calledClassName] = new $calledClassName();
        }

        return self::$_instances[$calledClassName];
    }

    /**
     * resets the cached instances. this method is necessary to run multiple unit tests
     */
    public static function clear() {
        self::$_instances = array();
    }

}
