<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;

use Svenbluege\Component\Eventgallery\Site\Library\Address;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<AddressFactory>
 */
class AddressFactory extends AbstractFactory
{


    /**
     * @param $data
     * @param $prefix
     *
     * @return Address()
     */
    public function createStaticAddress($data, $prefix)
    {
        $newData = array();
        foreach ($data as $key => $value) {
            $newData[str_replace($prefix, '', $key)] = $value;
        }

        $row = $this->store($newData, 'Staticaddress');
        return new Address($row);
    }

    /**
     * Determine an Address() object by a given ID.
     *
     * @param $id int the ID of an address
     * @return Address()
     */
    public function getAddressById($id) {
        $db = $this->db;

        $query = $db->getQuery(true);
        $query->select('*');
        $query->from('#__eventgallery_staticaddress');
        $query->where('id=' . $db->quote($id));

        $db->setQuery($query);
        return new Address($db->loadObject());
    }

}
