<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;

use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Svenbluege\Component\Eventgallery\Administrator\Table\CartTable;
use Svenbluege\Component\Eventgallery\Site\Library\Cart;

defined('_JEXEC') or die();
/**
 * @extends AbstractFactory<CartFactory>
 */
class CartFactory extends AbstractFactory
{

    /**
     * Trys to find a cart for the given user.
     *
     * @param $userId
     * @return Cart()
     */
    public function getCartByUserId($userId) {
        $db = $this->db;
        $query = $db->getQuery(true);

        $query->select('c.*');
        $query->from('#__eventgallery_cart as c');
        $query->where('c.statusid is null');
        $query->where('c.userid = ' . $db->quote($userId));
        $db->setQuery($query);

        $object = $db->loadObject();
        if (null == $object) {
            return null;
        }
        return new Cart($object);
    }

    /**
     * @param $id
     * @return Cart()|null
     */
    public function getCartById($id) {
        $db = $this->db;
        $query = $db->getQuery(true);

        $query->select('c.*');
        $query->from('#__eventgallery_cart as c');
        $query->where('c.id = ' . $db->quote($id));
        $db->setQuery($query);

        $object = $db->loadObject();
        if (null == $object) {
            return null;
        }
        return new Cart($object);
    }

    /**
     * creates a cart for the given user.
     *
     * @param $userId
     * @return Cart()
     * @throws Exception
     */
    public function createCart($userId) {
        $db = $this->db;
        $uuid = str_replace('.','0',uniqid("", true));
        $uuid = base_convert($uuid,16,10);

        /**
         * @var CartTable $table
         */

        // this code is necessary because I want to have a special id. If I don't
        // add the column first, the Joomla code would just try to fire updates
        // so a cart is never created.
        $query = $db->getQuery(true);
        $query->insert("#__eventgallery_cart");
        $query->columns(array("id, userid, email, phone, subtotalcurrency, totalcurrency"));
        $query->values($db->quote($uuid).','. $db->quote($userId).",'','', 0, ''");
        $db->setQuery($query);
        $db->execute();

        $table = Factory::getApplication()->bootComponent('com_eventgallery')->getMVCFactory()->createTable('Cart', 'Administrator');
        $table->userid = $userId;
        $table->id=$uuid;

        return new Cart($this->store((array)$table, 'Cart'));

    }

    /**
     * @param $email
     * @return array
     */
    public function getCartsByEmail($email) {
        $db = $this->db;
        $query = $db->getQuery(true);

        $query->select('id');
        $query->from('#__eventgallery_cart');
        $query->where('email = ' . $db->quote($email));
        $db->setQuery($query);

        $cartIds = $db->loadColumn(0);

        $carts = [];
        foreach($cartIds as $cartId) {
            array_push($carts, $this->getCartById($cartId));
        }

        return $carts;

    }


}
