<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;

use Svenbluege\Component\Eventgallery\Site\Library\EmailTemplate;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<EmailTemplateFactory>
 */
class EmailTemplateFactory extends AbstractFactory
{
    /**
     * Determines an email template by ID
     *
     * @param $id
     * @return EmailTemplate()
     */
    public function getEmailtemplateById($id) {

        $db = $this->db;
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from('#__eventgallery_emailtemplate');
        $query->where('id=' . $db->quote($id));

        $db->setQuery($query);
        $dbobject = $db->loadObject();

        return new EmailTemplate($dbobject);
    }

    /**
     * Searches a emailtemplate by key
     *
     * @param $key
     * @param string $languagetag
     * @param bool $publishedOnly
     * @return EmailTemplate()|null
     */
    public function getEmailtemplateByKey($key, $languagetag = '*', $publishedOnly = true) {
        $db = $this->db;
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from('#__eventgallery_emailtemplate');
        $query->where($db->quoteName('key').'=' . $db->quote($key));
        $query->where('language=' . $db->quote($languagetag));
        if ($publishedOnly) {
            $query->where('published=1');
        }
        $query->order('ordering');

        $db->setQuery($query);
        $element = $db->loadObject();

        if ($element == null) {
            // start searching for the global language fallback
            if ($languagetag != '*') {
                return $this->getEmailtemplateByKey($key, '*', $publishedOnly);
            }
            return null;
        }

        return new EmailTemplate($element);
    }


}
