<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main;
use Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\LocalFolder;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;
defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<FolderTypeFactory>
 */
class FolderTypeFactory extends AbstractFactory
{

    protected $_foldertype;
    protected $_foldertype_published;

    public function __construct() {
        $items = json_decode('[
          {
            "id": 0,
            "name": "local",
            "folderhandlerclassname": "\\\\Svenbluege\\\\Component\\\\Eventgallery\\\\Site\\\\Library\\\\Folder\\\\LocalFolder",
            "displayname": "Local Images",
            "default": 1,
            "ordering": 0,
            "published": 1
          },
          {
            "id": 2,
            "name": "flickr",
            "folderhandlerclassname": "\\\\Svenbluege\\\\Component\\\\Eventgallery\\\\Site\\\\Library\\\\Folder\\\\FlickrFolder",
            "displayname": "Flickr Images",
            "default": 0,
            "ordering": 2,
            "published": 1
          },
          {
            "id": 3,
            "name": "s3",
            "folderhandlerclassname": "\\\\Svenbluege\\\\Component\\\\Eventgallery\\\\Site\\\\Library\\\\Folder\\\\S3Folder",
            "displayname": "Amazon S3 Images",
            "default": 0,
            "ordering": 3,
            "published": 1
          },
          {
            "id": 4,
            "name": "googlephotos",
            "folderhandlerclassname": "\\\\Svenbluege\\\\Component\\\\Eventgallery\\\\Site\\\\Library\\\\Folder\\\\GooglePhotosFolder",
            "displayname": "Google Photos - API",
            "default": 0,
            "ordering": 4,
            "published": 1
          },
          {
            "id": 5,
            "name": "googlephotossharedpage",
            "folderhandlerclassname": "\\\\Svenbluege\\\\Component\\\\Eventgallery\\\\Site\\\\Library\\\\Folder\\\\GooglePhotosSharedPageFolder",
            "displayname": "Google Photos - Shared Page (Experimental)",
            "default": 0,
            "ordering": 5,
            "published": 1
          }
        ]');

        foreach ($items as $item) {
            /**
             * @var FolderType $itemObject
             */
            $itemObject = new FolderType($item);
            if ($itemObject->isPublished()) {
                $this->_foldertype_published[$itemObject->getId()] = $itemObject;
            }
            $this->_foldertype[$itemObject->getId()] = $itemObject;
        }

        parent::__construct();
    }

    /**
     * Return all folder types
     *
     * @param $publishedOnly
     * @return array
     */
    public function getFolderTypes($publishedOnly) {

        if ($publishedOnly) {
            return $this->_foldertype_published;
        } else {
            return $this->_foldertype;
        }
    }

    /**
     * Returns the default folder type
     *
     * @param bool $publishedOnly returns only published folder type
     * @return FolderType
     */
    public function getDefaultFolderType($publishedOnly) {
        $sets = array_values($this->getFolderTypes($publishedOnly));
        $config = Main::getInstance();
        $defaultFolderTypeId = $config->getGeneral()->getDefaultFolderTypeId();

        // select the configured default
        foreach ($sets as $set) {
            if ($set->getId() == $defaultFolderTypeId) {
                return $set;
            }
        }
        // take the first one
        if (isset($sets[0])) {
            return $sets[0];
        }
        return null;

    }

    /**
     * Determines a Folder Type by a given ID
     *
     * @param $id
     * @return FolderType
     */
    public function getFolderTypeById($id)
    {
        $sets = $this->getFolderTypes(false);
        if (isset($sets[$id]))
        {
            return $sets[$id];
        }
        return $this->getDefaultFolderType(true);

    }
}
