<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<GooglePhotosAccountFactory>
 */
class GooglePhotosAccountFactory extends AbstractFactory
{
    protected $_accounts;

    public function getAccountById($id) {

        $sets = $this->getAccounts();
        if (isset($sets[$id]))
        {
            return $sets[$id];
        }

        return null;
    }

    /**
     *
     *
     * @return GooglePhotosAccount[]
     */
    public function getUsableAccounts() {
        return array_filter($this->getAccounts(), function(/** @var GooglePhotosAccount $account */ $account) {
            return $account->isUsable();
        });
    }

    /**
     * @return GooglePhotosAccount[]
     */
    public function getAccounts() {

        if ($this->_accounts == null) {

            $db = $this->db;
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from('#__eventgallery_googlephotos_account');
            $query->order('ordering');
            $db->setQuery($query);
            $items = $db->loadObjectList();

            $this->_accounts = array();


            foreach ($items as $item) {
                /**
                 * @var GooglePhotosAccount $itemObject
                 */
                $itemObject = new GooglePhotosAccount($item);
                $this->_accounts[$itemObject->getId()] = $itemObject;
            }
        }

        return $this->_accounts;
    }

}
