<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;
use Svenbluege\Component\Eventgallery\Site\Library\Lineitem;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<ImageLineitemFactory>
 */
class ImageLineitemFactory extends LineitemFactory
{
    /**
     * name of the sql table like #__foobar
     */
    protected $_tablename = '#__eventgallery_imagelineitem';

    /**
     * @param $id
     * @return ImageLineitem()
     */
    public function getLineItemById($id)
    {
        $db = $this->db;
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->qn($this->_tablename));
        $query->where('id=' . $db->quote($id));
        $db->setQuery($query);
        $lineItem = $db->loadObject();
        $lineItem->table = $this->_tablename;

        return new ImageLineitem($lineItem);
    }

    /**
     * @param $id
     * @return array
     */
    public function getLineItemsByLineItemContainerId($id) {
        $db = $this->db;
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->qn($this->_tablename));
        $query->where('lineitemcontainerid = ' . $db->quote($id));
        $query->order('id');

        $db->setQuery($query);

        $dbLineItems = $db->loadObjectList();

        $lineitems = Array();
        foreach ($dbLineItems as $dbLineItem) {
            array_push($lineitems, new ImageLineitem($dbLineItem));
        }

        return $lineitems;
    }

    /**
     * @param $lineitemcontainerid
     * @param ImageLineitem() $lineitem
     *
     * @return ImageLineitem()
     */
    public function copyLineItem($lineitemcontainerid, $lineitem) {

        $data = get_object_vars($lineitem->_getInternalDataObject());
        unset($data['id']);
        $data['lineitemcontainerid'] = $lineitemcontainerid;
        $item = $this->store($data, 'Imagelineitem');

        return new ImageLineitem($item);
    }

    /**
     * @param int $lineitemcontainerid
     * @param string $foldername
     * @param string $filename
     * @param int $imagetypeid
     * @param int $quantity
     *
     * @return ImageLineitem()
     */
    public function createLineitem($lineitemcontainerid, $foldername, $filename, $imagetypeid, $quantity) {

        /**
         * @var FileFactory $fileFactory
         */
        $fileFactory = FileFactory::getInstance();
        $file = $fileFactory->getFile($foldername, $filename);



        $imagetype = $file->getImageTypeSet()->getImageType($imagetypeid);
        if ($imagetype==null) {
            $imagetype = $file->getImageTypeSet()->getDefaultImageType();
        }

        $item = array(
            'lineitemcontainerid' => $lineitemcontainerid,
            'folder' => $file->getFolderName(),
            'file' => $file->getFileName(),
            'original_filename' => $file->getOriginalFilename(),
            'original_filetitle' => $file->getRawFileTitle(),
            'original_filecaption' => $file->getRawFileCaption(),
            'quantity' => $quantity,
            'singleprice' => $imagetype->getPrice()->getAmount(),
            'price' => $quantity * $imagetype->getPrice()->getAmount(),
            'taxrate' => $imagetype->getTaxrate(),
            'currency' => $imagetype->getPrice()->getCurrency(),
            'imagetypeid' => $imagetype->getId()
        );


        $result = $this->store($item, 'Imagelineitem');

        return new ImageLineitem($result);
    }






}
