<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Interface\Method;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\AbstractMethod;

defined('_JEXEC') or die();


/**
 * @extends AbstractFactory<MethodFactory>
 */abstract class MethodFactory extends AbstractFactory
{
    /**
     * name of the sql table like #__foobar
     */
    protected $_methodtablename = null;

    /**
     * @var array
     */
    protected $_methods;

    /**
     * @var array
     */
    protected $_methods_published;

    /**
     * Determine an AbstractMethod object by a given ID.
     *
     * @param $id int the ID of an address
     * @param $publishedOnly
     * @return AbstractMethod
     */
    public function getMethodById($id, $publishedOnly) {
        $methods = $this->getMethods($publishedOnly);


        if (isset($methods[$id])) {
            return $methods[$id];
        }

        return null;
    }

    /**
     * @param bool $publishedOnly
     *
     * @return array
     */
    public function getMethods($publishedOnly = true)
    {

        if ($this->_methods == null) {

            $db = $this->db;
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from($db->qn($this->_methodtablename));
            $query->order('ordering');
            $db->setQuery($query);
            $items = $db->loadObjectList();

            $this->_methods = array();
            $this->_methods_published = array();

            foreach ($items as $item) {
                /**
                 * @var Method $itemObject
                 */
                if (class_exists($item->classname)) {
                    $itemObject = new $item->classname($item);
                    if ($item->published == 1) {
                        $this->_methods_published[$itemObject->getId()] = $itemObject;
                    }
                    $this->_methods[$itemObject->getId()] = $itemObject;
                }
            }
        }
        if ($publishedOnly) {
            return $this->_methods_published;
        } else {
            return $this->_methods;
        }
    }


    /**
     * @return Method
     */
    public function getDefaultMethod()
    {
        $methods = $this->getMethods(true);
        foreach ($methods as $method) {
            /**
             * @var Method $method
             */
            if ($method->isDefault()) {
                return $method;
            }
        }

        $array_values = array_values($methods);
        if (isset($array_values[0])) {
            return $array_values[0];
        }

        return NULL;
    }

    public function clearCache() {
        $this->_methods = null;
        $this->_methods_published = null;
    }


}
