<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\AbstractMethod;
use Svenbluege\Component\Eventgallery\Site\Library\ServiceLineitem;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<ServiceLineitemFactory>
 */
class ServiceLineitemFactory extends LineitemFactory
{

    /**
     * name of the sql table like #__foobar
     */
    protected $_tablename = '#__eventgallery_servicelineitem';

    /**
     * @param $id
     * @return ServiceLineitem
     */
    public function getLineItemById($id)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->qn($this->_tablename));
        $query->where('id=' . $db->quote($id));
        $db->setQuery($query);
        $lineItem = $db->loadObject();
        $lineItem->table = $this->_tablename;

        return new ServiceLineitem($lineItem);
    }

    /**
     * @param $id
     * @return array
     */
    public function getLineItemsByLineItemContainerId($id) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->qn($this->_tablename));
        $query->where('lineitemcontainerid = ' . $db->quote($id));
        $query->order('id');

        $db->setQuery($query);

        $dbLineItems = $db->loadObjectList();

        $lineitems = Array();
        foreach ($dbLineItems as $dbLineItem) {
            array_push($lineitems, new ServiceLineitem($dbLineItem));
        }

        return $lineitems;
    }

    /**
     * @param $lineitemcontainerid
     * @param ServiceLineitem $lineitem
     *
     * @return ServiceLineitem
     */
    public function copyLineItem($lineitemcontainerid, $lineitem) {

        $data = get_object_vars($lineitem->_getInternalDataObject());
        unset($data['id']);
        $data['lineitemcontainerid'] = $lineitemcontainerid;
        $item = $this->store($data, 'Servicelineitem');

        return new ServiceLineitem($item);
    }


    /**
     * @param LineitemContainer $lineitemcontainer
     * @param AbstractMethod $method
     * @return ServiceLineitem
     */
    public function createLineitem($lineitemcontainer, $method) {

        $quantity = 1;

        $price = $method->getPrice($lineitemcontainer);

        $item = array(
            'lineitemcontainerid' => $lineitemcontainer->getId(),
            'quantity' => $quantity,
            'singleprice' => $price->getAmount(),
            'price' => $quantity * $price->getAmount(),
            'taxrate' => $method->getTaxrate(),
            'currency' => $price->getCurrency(),
            'methodid' => $method->getId(),
            'type' => $method->getTypeCode(),
            'name' => $method->getName()
        );

        $item = $this->store($item, 'Servicelineitem');
        return new ServiceLineitem($item);
    }

    /**
     * Deletes all service line items of a given type from the given Lineitemcontainer
     *
     * @param $id
     * @param $methodtypeid
     */
    public function deleteMethodTypeFromLineitemContainer($id, $methodtypeid)
    {
        $db = $this->db;
        $query = $db->getQuery(true);
        $query->delete('#__eventgallery_servicelineitem');
        $query->where('type=' . $db->quote($methodtypeid));
        $query->where('lineitemcontainerid=' . $db->quote($id));
        $db->setQuery($query);
        $db->execute();
    }
}
