<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Factory;
use Joomla\CMS\Helper\TagsHelper;
use Svenbluege\Component\Eventgallery\Site\Library\ImageType;

defined('_JEXEC') or die();

/**
 * @extends AbstractFactory<TagsFactory>
 */
class TagsFactory extends AbstractFactory
{
    protected $_tags = [];

    /**
     * Searches and caches the tags for a folder
     *
     * @param $id
     * @return ImageType
     */
    public function getTagsForFolderId($id) {
        $tags = null;
        if (isset($this->_tags[$id])) {
            $tags = $this->_tags[$id];
        } else {
            $helperTags = new TagsHelper();
            $tags = $helperTags->getItemTags('com_eventgallery.event', $id);
            $this->_tags[$id] = $tags;
        }
        return $this->_tags[$id];
    }

    /*
     * We can prefill the cache for this class. This is helpful to prevent many small queries
     * if we call @getTagsForFolderId for many folders.
     */
    public function prefillCache($ids) {
        if ($ids == null || empty($ids)) {
            return;
        }

        $ids = array_diff($ids, array_keys($this->_tags));
        if (empty($ids)) {
            return;
        }

        $helperTags = new TagsHelper();
        $tags = $helperTags->getMultipleItemTags('com_eventgallery.event', $ids);
        $keys = array_keys($tags);
        foreach ($keys as $key) {
            $this->_tags[$key] = $tags[$key];
        }
    }

    public static function clear() {

        /**
         * @var TagsFactory $tagsFactory
         */
        $tagsFactory = self::getInstance();
        $tagsFactory->_tags = null;

        parent::clear();
    }
}


