<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\File;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\GooglePhotosFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\SizeSet;

defined('_JEXEC') or die();


class GooglePhotosSharedPageFile extends File
{

    /**
     * @var GooglePhotosFolder
     */
    protected $_folder;

    private $imageRatio;

    public $_google_loading_script_path = COM_EVENTGALLERY_GOOGLEPHOTOS_LOADING_IMAGE_PATH.'/gp.svg';

    /**
     * creates the lineitem object. The foldername can either be a string or a file data object
     *
     * @param object $object
     */
    /** @noinspection PhpMissingParentConstructorInspection */
    function __construct($object)
    {
        parent::__construct($object);

        if (isset($this->_file->height)) {
            $this->imageRatio = $this->_file->width / $this->_file->height;
        } else {
            $this->imageRatio = 1;
        }
    }

    /**
     * @return int
     */
    public function getLightboxImageWidth() {
        return $this->getWidth();
    }

    /**
     * @return int
     */
    public function getLightboxImageHeight() {
        return $this->getHeight();
    }

    /**
     * @return GooglePhotosFolder
     */
    public function getFolder() {
        return $this->_folder;
    }

    public function getImageSrcSet() {
        $sizes = [1200, 2400, 3600];
        $sourceSet = [];

        foreach ($sizes as $size) {
            if ($size > $this->getWidth()) {
                continue;
            }
            $sourceSet[] = $this->getGoogleImageUrl($size) . ' ' . $size . 'w';
        }

        return join(', ', $sourceSet);
    }

    public function getImageUrl($width, $height, $fullsize=false, $larger = false, $relative=false)
    {
        $url = "";

        if ($this->_file == null) {
            return $url;
        }

        if ($fullsize) {
            $url =  $this->getThumbUrl(COM_EVENTGALLERY_IMAGE_ORIGINAL_MAX_WIDTH, COM_EVENTGALLERY_IMAGE_ORIGINAL_MAX_WIDTH);
        } else {
            if ($this->imageRatio < 1) {
                $url = $this->getThumbUrl($height * $this->imageRatio, $height, $larger);
            } else {
                $url =  $this->getThumbUrl($width, $width / $this->imageRatio, $larger);
            }
        }

        return $url;
    }

    /**
     * Details for URL generation: https://developers.google.com/photos/library/guides/access-media-items?hl=en#base-urls
     *
     * @return string
     */
    public function getVideoUrl()
    {
        return $this->getBaseUrl() . '=dv';
    }
    public function getThumbUrl($width = 104, $height = 104, $larger = true, $relative=false)
    {

        if ($this->_file == null) {
            return "";
        }

        if ($width == 0) {
            $width = 104;
        }
        if ($height == 0) {
            $height = 104;
        }


        if ($this->_file->width > $this->_file->height) {
            // querformat
            $googlewidth = $width;
            $resultingHeight = $googlewidth / $this->imageRatio;
            if ($resultingHeight < $height) {
                $googlewidth = round($height * $this->imageRatio);
            }
        } else {
            //hochformat
            $googlewidth = $height;
            $resultingWidth = $googlewidth * $this->imageRatio;
            if ($resultingWidth < $width) {
                $googlewidth = round($height / $this->imageRatio);
            }
        }

        $sizeSet = new SizeSet();
        $saveAsSize = $sizeSet->getMatchingSize($googlewidth);

        $thumbUrl = $this->getGoogleImageUrl($saveAsSize);

        return $thumbUrl;
    }

    public function getOriginalImageUrl($forceOriginalFile = false) {
        $url = Uri::base().substr( Route::_('index.php?option=com_eventgallery&view=download&folder='.$this->getFolderName().'&file='.urlencode($this->getFileName()) ), strlen(Uri::base(true)) + 1);
        $url = str_replace('/administrator/','/', $url);
        return $url;
    }

    public function getSharingImageUrl() {
        $url = Uri::base().substr( Route::_('index.php?option=com_eventgallery&is_for_sharing=true&view=download&folder='.$this->getFolderName().'&file='.urlencode($this->getFileName()) ), strlen(Uri::base(true)) + 1);
        $url = str_replace('/administrator/','/', $url);
        return $url;

    }

    public function getBaseUrl() {
        return $this->_file->googlephotos_baseurl;
    }

    /**
     * returns the filename which was used to upload that file to Google Photos
     *
     * @return |null
     */
    public function getOriginalFilename() {
        return $this->_file->googlephotos_filename;
    }

    public function getGoogleImageUrl($width) {
        return $this->getBaseUrl() . "=w" . $width . '-nu';
    }

}
