<?php

namespace Svenbluege\Component\Eventgallery\Site\Library;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\Component\Finder\Administrator\Indexer\Adapter;
use Joomla\Component\Finder\Administrator\Indexer\Result;

class FinderAdapter extends Adapter
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.1
     */
    protected $autoloadLanguage = true;

    public function init() {
        $this->getApplication()->bootComponent('com_eventgallery');
        $this->loadLanguage();
    }

    protected function getLocalizedUrl($id, $extension, $view, $language) {
        return $this->getUrl($id, $extension, $view) . '&lang=' . $language;
    }

    protected function remove($id, $removeTaxonomies = true)
    {
        if (!Multilanguage::isEnabled()) {
            $this->removeLocalized($id, $removeTaxonomies, '');
            return;
        }

        $languages = LanguageHelper::getLanguages();
        foreach ($languages as $lang) {
            $this->removeLocalized($id, $removeTaxonomies, $lang->lang_code);
        }
    }
    protected function removeLocalized($id, $removeTaxonomies, $language)
    {
        // Get the item's URL
        $url = $this->db->quote($this->getLocalizedUrl($id, $this->extension, $this->layout, $language));

        // Get the link ids for the content items.
        $query = $this->db->getQuery(true)
            ->select($this->db->quoteName('link_id'))
            ->from($this->db->quoteName('#__finder_links'))
            ->where($this->db->quoteName('url') . ' = ' . $url);
        $this->db->setQuery($query);
        $items = $this->db->loadColumn();

        // Check the items.
        if (empty($items)) {
            Factory::getApplication()->triggerEvent('onFinderIndexAfterDelete', [$id]);

            return true;
        }

        // Remove the items.
        foreach ($items as $item) {
            $this->indexer->remove($item, $removeTaxonomies);
        }

        return true;
    }

    protected function index(Result $item, $format = 'html') {
        if (!Multilanguage::isEnabled()) {
            $this->indexLanguage($item, $format, '');
            return;
        }

        $languages = LanguageHelper::getLanguages();
        foreach ($languages as $lang) {
            $localizedItem = clone $item;
            $this->indexLanguage($localizedItem, $format, $lang->lang_code);
        }
    }

    /**
     * Method to setup the indexer to be run.
     *
     * @return  boolean  True on success.
     *
     * @since   2.5
     */
    protected function setup()
    {
        return true;
    }


    /**
     * Method to get the query clause for getting items to update by time.
     *
     * @param   string  $time  The modified timestamp.
     *
     * @return  JDatabaseQuery  A database object.
     *
     * @since   2.5
     */
    protected function getUpdateQueryByTime($time)
    {
        // Build an SQL query based on the modified time.
        $query = $this->db->getQuery(true)
            ->where('a.modified >= ' . $this->db->quote($time));

        return $query;
    }

}
