<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library;
use Svenbluege\Component\Eventgallery\Administrator\Table\FlickraccountTable;
use Svenbluege\Component\Eventgallery\Site\Library\Database\DatabaseObject;

defined('_JEXEC') or die();

class FlickrAccount extends DatabaseObject
{

    /**
     * @var FlickraccountTable
     */
    protected $_flickrsaccount = NULL;
    protected $_flickraccount_id = NULL;

    public function __construct($dbFlickrAccount)
    {
        if (!is_object($dbFlickrAccount)) {
            throw new \InvalidArgumentException("Can't initialize Flickr Account Object without a Data Object.");
        }
        $this->_flickrsaccount = $dbFlickrAccount;
        $this->_flickraccount_id = $dbFlickrAccount->id;



        parent::__construct();
    }

    public function getId()
    {
        return $this->_flickrsaccount->id;
    }

    public function getName()
    {
        return $this->_flickrsaccount->name;
    }


    public function getDescription()
    {
        return $this->_flickrsaccount->description;
    }

    public function getUserId() {
        return $this->_flickrsaccount->user_id;
    }

    public function getAPIKey() {
        return $this->_flickrsaccount->api_key;
    }

    public function getAPISecret() {
        return $this->_flickrsaccount->api_secret;
    }

    public function getAuthToken() {
        return $this->_flickrsaccount->auth_token;
    }

    public function getAuthTokenSecret() {
        return $this->_flickrsaccount->auth_token_secret;
    }

    public function isPublished() {
        return $this->_flickrsaccount->published==1;
    }

    public function getOrdering() {
        return $this->_flickrsaccount->ordering;
    }

    /**
     * return true if all the necessary data is set.
     *
     * @return bool
     */
    public function isUsable() {
        return !empty($this->getUserId());
    }


}
