<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Folder;
defined('_JEXEC') or die();

/**
 * Simple Class so store the result if we try to add the folder to the database.
 *
 * Class AddResult
 */
class AddResult
{
    /**
     * @var String
     */
    public $error;

    /**
     * @var String
     */
    public $foldername;

    /**
     * @var int
     */
    public $foldertype;

    /**
     * @return int
     */
    public function getFoldertype()
    {
        return $this->foldertype;
    }

    /**
     * @param int $foldertype
     */
    public function setFoldertype($foldertype)
    {
        $this->foldertype = $foldertype;
    }

    /**
     * @return String
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param String $error
     */
    public function setError($error)
    {
        $this->error = $error;
    }

    /**
     * @return String
     */
    public function getFolderName()
    {
        return $this->foldername;
    }

    /**
     * @param String $folder
     */
    public function setFolderName($foldername)
    {
        $this->foldername = $foldername;
    }
}
