<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Folder;
defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use \Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\File\FlickrFileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\FlickrFile;
use Svenbluege\Component\Eventgallery\Site\Library\FlickrAccount;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\FolderManager;

class FlickrFolder extends Folder
{
    const ID = 2;

    /**
     * @var bool defines if we already updated this album during the request.
     */
    private $_photoSet_updated = false;

    /**
     * @param int $limitstart
     * @param int $limit
     * @param int $imagesForEvents if true load the main images at the first position
     * @return array
     */
    public function getFiles($limitstart = 0, $limit = 0, $imagesForEvents = 0, $sortAttribute='', $sortDirection='ASC', $doOverridewithFolderSettings = true) {

        $this->updatePhotoSet();

        $result = parent::getFiles($limitstart, $limit, $imagesForEvents, $sortAttribute, $sortDirection, $doOverridewithFolderSettings);
        if (EVENTGALLERY_EXTENDED || defined ('COM_EVENTGALLERY_I_USE_FLICKR_SINCE_A_LONG_TIME')) {
            return $result;
        } else {
            return array_slice($result, 0, 30);
        }
    }

    /**
     * returns the photoset id
     *
     * @return string
     */
    public function getPhotoSetId() {
        return $this->_foldername;
    }

    /**
     * Updates the photoset;
     *
     */
    public function updatePhotoSet() {
        if ($this->_photoSet_updated === false) {
            $this->_photoSet_updated = true;

            $db = Factory::getDbo();

            $cachelifetime = $this->config->getGeneral()->getFlickrCacheLifetime();
            $legacy_api_key = $this->config->getGeneral()->getFlickrAPIKey();
            $account = $this->getFlickrAccount();

            FlickrConnector::updatePhotoSet($account, $cachelifetime, $db, $this->getPhotoSetId(), $legacy_api_key);
        }
    }

    public function getFlickrAccountId() {
        return $this->_folder->flickraccountid;
    }

    public function getFlickrTitle() {
        return $this->_folder->flickrtitle;
    }

    /**
     * @return FlickrAccount
     */
    public function getFlickrAccount() {
        /**
         * @var FlickrAccountFactory $accountFactory
         *
         */
        $accountFactory = FlickrAccountFactory::getInstance();
        return $accountFactory->getAccountById($this->getFlickrAccountId());
    }

    public static function syncFolder($foldername, $use_htacces_to_protect_original_files) {
        return ['status' => FolderManager::$SYNC_STATUS_NOSYNC];
    }

    public static function findNewFolders() {
        return Array();
    }

    public static function getFileFactory() {
        return FlickrFileFactory::getInstance();
    }

    public function isSortable() {
        return false;
    }

    public function supportsFileUpload() {
        return false;
    }

    public function supportsFileDeletion() {
        return false;
    }

    public function supportsThumbnailDeletion() {
        return false;
    }

    public function supportsImageDataEditing() {
        return false;
    }

    public function  supportsFileHitCount() {
        return false;
    }
}
