<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Folder;
defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use \Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\File\GooglePhotosFileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\GooglePhotosFile;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\FolderManager;

class GooglePhotosFolder extends Folder
{
    const ID = 4;

    private $_album_updated = false;
    private $_albums_updated = false;

    /**
     * @param int $limitstart
     * @param int $limit
     * @param int $imagesForEvents if true load the main images at the first position
     * @return array
     */
    public function getFiles($limitstart = 0, $limit = 0, $imagesForEvents = 0, $sortAttribute='', $sortDirection='ASC', $doOverridewithFolderSettings = true) {

        if ($imagesForEvents == 1) {
            $this->updateAlbums();
        } else {
            $this->updateAlbum();
        }

        $result =  parent::getFiles($limitstart, $limit, $imagesForEvents, $sortAttribute, $sortDirection, $doOverridewithFolderSettings);

        if (EVENTGALLERY_EXTENDED) {
            return $result;
        } else {
            return array_slice($result, 0, 30);
        }
    }

    /**
     * This special method uses a fixed cache lifetime so we can get data from Google more often.
     *
     * @param int $limitstart
     * @param int $limit
     * @param int $imagesForEvents
     * @param string $sortAttribute
     * @param string $sortDirection
     * @return array
     */
    public function getFilesForImages($limitstart = 0, $limit = 0, $imagesForEvents = 0, $sortAttribute='', $sortDirection='ASC') {

        if ($imagesForEvents == 1) {
            $this->updateAlbums(COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_CACHE_LIFETIME);
        } else {
            $this->updateAlbum(COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_CACHE_LIFETIME);
        }

        return parent::getFiles($limitstart, $limit, $imagesForEvents, $sortAttribute, $sortDirection);
    }

    public function getGooglePhotosAccountId() {
        return $this->_folder->googlephotosaccountid;
    }

    public function getGooglePhotosTitle() {
        return $this->_folder->googlephotostitle;
    }

    public function getGooglePhotosAccount() {
        /**
        * @var GooglePhotosAccountFactory $accountFactory
        *
        */
        $accountFactory = GooglePhotosAccountFactory::getInstance();
        return $accountFactory->getAccountById($this->getGooglePhotosAccountId());
    }

    /**
     * returns the Google Photos Album id
     *
     * @return string
     */
    public function getAlbumId() {
        return $this->_foldername;
    }

    /**
     * Updates the album
     */
    public function updateAlbum($cachelifetime = null) {
        if ($this->_album_updated == NULL) {
            $this->_album_updated = true;

            $cachelifetime = $cachelifetime != null?$cachelifetime : GooglePhotosConnector::$cache_life;
            $account = $this->getGooglePhotosAccount();
            if ($account == null || !$account->isUsable()) {
                Factory::getApplication()->enqueueMessage( Text::sprintf('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_FOR_EVENT_INVALID', $this->getDisplayName()));
                return;
            }
            $refresh_token = $account->getRefreshToken();
            $api_clientid = $account->getClientId();
            $api_secret = $account->getSecret();

            GooglePhotosConnector::syncAlbum($cachelifetime, $api_clientid, $api_secret, $refresh_token, Factory::getDbo(), $this->getAlbumId());
        }
    }

    /**
     * Updates the album
     */
    public function updateAlbums($cachelifetime = null) {
        if ($this->_albums_updated == NULL) {
            $this->_albums_updated = true;

            $cachelifetime = $cachelifetime != null?$cachelifetime : GooglePhotosConnector::$cache_life;

            /**
             * @var GooglePhotosAccountFactory $accountFactory
             *
             */
            $accountFactory = GooglePhotosAccountFactory::getInstance();
            $accounts = $accountFactory->getUsableAccounts();

            foreach($accounts as $account) {
                $refresh_token = $account->getRefreshToken();
                $api_clientid = $account->getClientId();
                $api_secret = $account->getSecret();

                GooglePhotosConnector::syncAlbums($cachelifetime, $api_clientid, $api_secret, $refresh_token, Factory::getDbo());
            }
        }
    }

    public static function syncFolder($foldername, $use_htacces_to_protect_original_files) {
        return ['status' => FolderManager::$SYNC_STATUS_NOSYNC];
    }

    public static function findNewFolders() {
        return Array();
    }

    public static function getFileFactory() {
        return GooglePhotosFileFactory::getInstance();
    }

    public function isSortable() {
        return false;
    }

    public function supportsFileUpload() {
        return false;
    }

    public function supportsFileDeletion() {
        return false;
    }

    public function supportsThumbnailDeletion() {
        return false;
    }

    public function supportsImageDataEditing() {
        return false;
    }

    public function  supportsFileHitCount() {
        return false;
    }
}
