<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Folder;
defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use \Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosSharedPageConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\File\GooglePhotosSharedPageFileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\FolderManager;

class GooglePhotosSharedPageFolder extends Folder
{
    const ID = 5;

    private $_album_updated = false;
    private $_albums_updated = false;

    /**
     * @param int $limitstart
     * @param int $limit
     * @param int $imagesForEvents if true load the main images at the first position
     * @return array
     */
    public function getFiles($limitstart = 0, $limit = 0, $imagesForEvents = 0, $sortAttribute='', $sortDirection='ASC', $doOverridewithFolderSettings = true) {

        $this->updateAlbum();

        $result =  parent::getFiles($limitstart, $limit, $imagesForEvents, $sortAttribute, $sortDirection, $doOverridewithFolderSettings);

        if (EVENTGALLERY_EXTENDED) {
            return $result;
        } else {
            return array_slice($result, 0, 30);
        }
    }

    /**
     * This special method uses a fixed cache lifetime so we can get data from Google more often.
     *
     * @param int $limitstart
     * @param int $limit
     * @param int $imagesForEvents
     * @param string $sortAttribute
     * @param string $sortDirection
     * @return array
     */
    public function getFilesForImages($limitstart = 0, $limit = 0, $imagesForEvents = 0, $sortAttribute='', $sortDirection='ASC') {
        $this->updateAlbum();
        return parent::getFiles($limitstart, $limit, $imagesForEvents, $sortAttribute, $sortDirection);
    }

    /**
     * Updates the album
     */
    public function updateAlbum($cachelifetime = null) {
        if ($this->_album_updated == NULL) {
            $this->_album_updated = true;

            $cachelifetime = $cachelifetime != null?$cachelifetime : GooglePhotosSharedPageConnector::$cache_life;

            GooglePhotosSharedPageConnector::syncAlbum($cachelifetime, Factory::getDbo(), $this->getFolderName(), $this->getGooglePhotosSharedPageUrl());
        }
    }

    public static function syncFolder($foldername, $use_htacces_to_protect_original_files) {
        return ['status' => FolderManager::$SYNC_STATUS_NOSYNC];
    }

    public static function findNewFolders() {
        return Array();
    }

    public static function getFileFactory() {
        return GooglePhotosSharedPageFileFactory::getInstance();
    }

    public function isSortable() {
        return true;
    }

    public function supportsFileUpload() {
        return false;
    }

    public function supportsFileDeletion() {
        return false;
    }

    public function supportsThumbnailDeletion() {
        return false;
    }

    public function supportsImageDataEditing() {
        return true;
    }

    public function  supportsFileHitCount() {
        return false;
    }

    public function isCartable()
    {
        return parent::isCartable();
    }

    public function getGooglePhotosSharedPageUrl() {
        return $this->_folder->googlephotossharedpageurl;
    }

}
