<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Helper;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;

defined('_JEXEC') or die;

/**
 * transforms a link pattern into a real link.
 */
class CartConnector
{

    /**
     * @param $file File
     * @return string
     */
    public static function getLink($file)
    {
        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $params = $app->getParams();

        $linkPattern = $params->get('cart_connector_link', '');

        $fileBase = pathinfo($file->getFileName(), PATHINFO_FILENAME);


        $linkPattern = str_replace('{folder}', $file->getFolderName(), $linkPattern);
        $linkPattern = str_replace('{file}', $file->getFileName(), $linkPattern);
        $linkPattern = str_replace('{fileBase}', $fileBase, $linkPattern);
        if ($file->getFolder()->getCategory() != null) {
            $linkPattern = str_replace('{categoryId}', $file->getFolder()->getCategory()->id, $linkPattern);
            $linkPattern = str_replace('{categorySlug}', $file->getFolder()->getCategory()->slug, $linkPattern);
            $linkPattern = str_replace('{categoryTitle}', $file->getFolder()->getCategory()->title, $linkPattern);
        }

        return $linkPattern;
    }
}
