<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Helper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;



class MediaLoader
{

    static $loaded = false;

    /**
     * @param Svenbluege\Component\Eventgallery\Site\Library\Configuration\ $config
     * @throws Exception
     */
    public static function loadMedia($config = null)
    {

        if (self::$loaded) {
            return;
        }

        self::$loaded = true;

        $document = Factory::getDocument();
        $app = Factory::getApplication();

        \Joomla\CMS\HTML\HTMLHelper::_('behavior.formvalidator');

        if ($config == null) {
            $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        }

        $doDebug = $config->getGeneral()->doDebug();
        $doManualDebug = $app->input->getString('debug', '') == 'true';
		$loadResponsiveCSS = $config->getGeneral()->doLoadResponsiveCSS();

        $CSSs = Array();
        $JSs = Array();


        // load script and styles in debug mode or compressed
        if ($doDebug || $doManualDebug) {

            $CSSs[] = 'dist/eventgallery-debug.css';
            if ($loadResponsiveCSS == 1) {
                $CSSs[] = 'dist/responsive-static-debug.css';
            }
            if ($loadResponsiveCSS == 2) {
                $CSSs[] = 'dist/responsive-fluid-debug.css';
            }
            $JSs[] = 'dist/eventgallery-debug.js';

        } else {
            $CSSs[] = 'dist/eventgallery.css';
            if ($loadResponsiveCSS == 1) {
                $CSSs[] = 'dist/responsive-static.css';
            }
            if ($loadResponsiveCSS == 2) {
                $CSSs[] = 'dist/responsive-fluid.css';
            }
            $JSs[] = 'dist/eventgallery.js';
        }

        foreach($CSSs as $css) {
            $script = Uri::root(true) . '/media/com_eventgallery/'.$css.'?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
            $document->addStyleSheet($script);
        }

        foreach($JSs as $js) {
            $script = Uri::root(true) . '/media/com_eventgallery/'.$js.'?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
            $document->addScript($script);
        }


        $lightboxConfiguration = Array();
        $lightboxConfiguration['navigationFadeDelay'] = $config->getLightbox()->getNavigationFadeDelay();
        $lightboxConfiguration['slideshowSpeed'] = $config->getLightbox()->getSlideshowSpeed();
        $lightboxConfiguration['doUseSlideshow'] = $config->getLightbox()->doUseSlideshow();
        $lightboxConfiguration['doUseAutoplay'] = $config->getLightbox()->doUseAutoplay();
        $lightboxConfiguration['doTrackImageHits'] = $config->getLightbox()->doTrackImageHits();
        $lightboxConfiguration['trackImageHitsUrl'] = Uri::root(true) . Route::_('/api/index.php/v1/eventgallery/imagehitcounter');

        $lightboxConfiguration['KEY_CLOSE'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_CLOSE');
        $lightboxConfiguration['KEY_SHARE'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_SHARE');
        $lightboxConfiguration['KEY_DOWNLOAD'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_DOWNLOAD');
        $lightboxConfiguration['KEY_BUY'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_BUY');
        $lightboxConfiguration['KEY_ZOOM'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_ZOOM');
        $lightboxConfiguration['KEY_PREVIOUS'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_PREVIOUS');
        $lightboxConfiguration['KEY_NEXT'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_NEXT');
        $lightboxConfiguration['KEY_FULLSCREEN'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_FULLSCREEN');
        $lightboxConfiguration['KEY_PLAYSLIDESHOW'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_PLAYSLIDESHOW');
        $lightboxConfiguration['KEY_PAUSESLIDESHOW'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LIGHTBOX_PAUSESLIDESHOW');
        $document->addScriptDeclaration("window.EventGalleryLightboxConfiguration=" . json_encode($lightboxConfiguration) . ";");

        $cartConfiguration = Array();
        $cartConfiguration['add2cartdialogurl'] =  Route::_('index.php?option=com_eventgallery&view=singleimage&layout=imagesetselection&format=raw', false);
        $cartConfiguration['removeUrl'] =  Route::_("index.php?option=com_eventgallery&view=rest&task=removefromcart&format=raw", false);
        $cartConfiguration['add2cartUrl'] =  Route::_("index.php?option=com_eventgallery&view=rest&task=add2cart&format=raw", false);
        $cartConfiguration['getCartUrl'] =  Route::_("index.php?option=com_eventgallery&view=rest&task=getCart&format=raw", false);
        $cartConfiguration['removeLinkTitle'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_ITEM_REMOVE');
        $cartConfiguration['removeAllItemsWarning'] = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_FORM_REMOVE_ALL_CONFIRM');
        $document->addScriptDeclaration("window.EventGalleryCartConfiguration=" . json_encode($cartConfiguration) . ";");

        $googlePhotosConfiguration = Array();
        $googlePhotosConfiguration['albumUrl'] =  Route::_('index.php?option=com_eventgallery&view=googlephotosapi&task=getAlbum&format=raw', false);
        $googlePhotosConfiguration['albumsUrl'] =  Route::_('index.php?option=com_eventgallery&view=googlephotosapi&task=getAlbums&format=raw', false);


        $document->addScriptDeclaration("window.EventGalleryGooglePhotosConfiguration=" . json_encode($googlePhotosConfiguration) . ";");
    }

    public static function loadLanguage($app) {
        $language = $app->getLanguage();
        $language->load('com_eventgallery');
        $language->load('com_eventgallery' , JPATH_BASE.DIRECTORY_SEPARATOR.'language'.DIRECTORY_SEPARATOR.'overrides');
        $language->load('com_eventgallery' , JPATH_BASE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_eventgallery');
    }

}



