<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Helper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class PluginHelper {
    public static function findWorkingClass($app, $plugin_folder, $classname) {
        $plugins = \Joomla\CMS\Plugin\PluginHelper::getPlugin($plugin_folder);
        foreach($plugins as $plugin) {
            $bootedPlugin = $app->bootPlugin($plugin->name, $plugin->type);

            if (method_exists($bootedPlugin, 'getWorkingClass') && $bootedPlugin->getWorkingClass() == $classname) {
                return $bootedPlugin->getWorkingClass();
            }
        }
        return null;
    }
}
