<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Helper;

use Svenbluege\Component\Eventgallery\Site\Library\Common\RouteHelper;

defined('_JEXEC') or die;

abstract class Route
{
    protected static $routehelper = null;

    protected static function getRouteHelper() {
        if (self::$routehelper == null) {
            self::$routehelper = new RouteHelper();
        }
        return self::$routehelper;
    }

    public static function getCategoryRoute($catid, /** @noinspection PhpUnusedParameterInspection */$language = 0) {
        return self::getRouteHelper()->getCategoryRoute($catid, $language);
    }

    /**
     * creates a link based on a category id
     * @param $catid
     * @param null $itemid
     * @throws Exception
     * @return string
     */
    public static function createCategoryRoute($catid, $itemid = null) {
        return self::getRouteHelper()->createCategoryRoute($catid, $itemid);
    }

    /**
     * create the route for a ucm link like from the tag component.
     *
     * @param $id
     * @param int $catid
     * @param int $language
     */
    public static function getEventRoute($id, $catid = 0, $language = 0, $layout = null) {
        return self::getRouteHelper()->getEventRoute($id, $catid, $language, $layout);
    }

    /**
     * creates a link to an event
     * @param $foldername
     * @param array $tags
     * @param $catid
     * @param null $itemid
     * @params String $targetLanguageCode
     * @throws Exception
     * @return string
     */
    public static function createEventRoute($foldername, $tags, $catid, $itemid = null, $targetLanguageCode = null)
    {
        return self::getRouteHelper()->createEventRoute($foldername, $tags, $catid, $itemid, $targetLanguageCode);
    }

    /**
     * @param $targetLanguageCode
     * @param array $tags
     * @param $catid
     * @param $foldername
     * @param $itemid
     * @return \Joomla\CMS\Menu\MenuItem
     */
    public static function getMenuItemidForEvent($targetLanguageCode, $tags, $catid, $foldername, $itemid)
    {
        return self::getRouteHelper()->getMenuItemidForEvent($targetLanguageCode, $tags, $catid, $foldername, $itemid);
    }
}


