<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Interface;
defined('_JEXEC') or die;

interface  FolderCapability {

    /**
     * Defines if a folder is sortable using the back office
     *
     * @return boolean
     */
    public function isSortable();

    /**
     * does the folder supports uploads?
     *
     * @return boolean
     */
    public function supportsFileUpload();

    /**
     * does the folder supports file deletion?
     *
     * @return boolean
     */
    public function supportsFileDeletion();

    public function supportsThumbnailDeletion();

    /**
     * defines if the folder has files where you can edit meta data.
     *
     * @return boolean
     */
    public function supportsImageDataEditing();

    /**
     * defines if this kinf of folder supports counting file hits.
     *
     * @return boolean
     */
    public function supportsFileHitCount();

}
