<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Library\Interface;
use Svenbluege\Component\Eventgallery\Site\Library\Data\Exif;
use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;

defined('_JEXEC') or die;


interface Image
{

    /**
     * @param int $width
     * @param int $height
     * @param string $cssClass
     * @param bool $crop
     * @param $alternateThumbUrl String In case we don't want to use the default url.
     * @return string
     */
    public function getThumbImgTag($width, $height, $cssClass, $crop, $alternateThumbUrl, $showImageTitle, $showImageCaption);

    public function getLazyThumbImgTag($width, $height, $cssClass, $crop, $customDataAttributes, $showImageTitle, $showImageCaption);

    public function getImageUrl($width, $height, $fullsize=false, $larger = false, $relative=false);

    public function getImageSrcSet();

    public function getVideoUrl();

    public function getThumbUrl($width = 104, $height = 104, $larger = true, $relative=false);

	/**
	 * Returns the original download url for the image
	 *
	 * @param   bool  $forceOriginalFile  we can use this if we need a smaller file usually, but only for orders the real original file.
	 *                                    Example: size restriction in Flickr.
	 *
	 * @return mixed
	 */
    public function getOriginalImageUrl($forceOriginalFile = false);

    /**
     * returns a url which provides the image url to be read by Facebook & stuff
     *
     * @return String
     */
    public function getSharingImageUrl();
    /**
     * @param ImageLineitem $lineitem
     *
     * @return string
     */
    public function getMiniCartThumb($lineitem);

    /**
     * @param ImageLineitem $lineitem
     *
     * @return string
     */
    public function getCartThumb($lineitem);

    /**
     * @param ImageLineitem $lineitem
     *
     * @return string
     */
    public function getOrderThumb($lineitem);

    /**
     * Returns an URL which can be used to show images even if they are protected
     *
     * @param ImageLineitem $lineitem
     *
     * @return string
     */
    public function getMailThumbUrl($lineitem);

    /**
     * returns the binary file.
     *
     * @return mixed
     */
    public function getOriginalFile();

    /**
     * @return Exif
     */
    public function getExif();

    /**
     * Delete the image from disk/cloud/whatever
     *
     * @return bool
     */
    public function deleteImageFile();

    public function createThumbnails();

}
