<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Manager;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\AddResult;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;
use Symfony\Component\Console\Style\SymfonyStyle;

defined('_JEXEC') or die();

class FolderManager extends AbstractManager
{

    public static $SYNC_STATUS_NOSYNC = 0;
    public static $SYNC_STATUS_SYNC = 1;
    public static $SYNC_STATUS_DELTED = 2;
    public static $SYNC_STATUS_FAILED = 3;

    private $_folders = null;

    /**
     * scans the main dir and adds new folders to the database
     * Does not add Files!
     *
     * @return AddResult[]
     */
    public function findNewFolders() {

        $newFolders = Array();

        /**
         * @var FolderTypeFactory $foldertypeFactory
         * @var FolderType $folderType
         */
        $foldertypeFactory = FolderTypeFactory::getInstance();

        foreach($foldertypeFactory->getFolderTypes(true) as $folderType) {
            $folderClass = $folderType->getFolderHandlerClassname();
            /**
             * @var Folder $folderClass
             * */
            $newFolders = array_merge($newFolders, $folderClass::findNewFolders());
        }

        return $newFolders;
    }

    public function addNewFolders() {
        $newFolders = self::findNewFolders();
        foreach($newFolders as $newFolder) {
            /**
             * @var $newFolder AddResult
             */
            self::addNewFolder($newFolder->foldername, $newFolder->foldertype);
        }

        return $newFolders;
    }

    public function addNewFolder($folder, $foldertype) {
        /**
         * @var FolderTypeFactory $foldertypeFactory
         * @var FolderType $folderType
         */
        $foldertypeFactory = FolderTypeFactory::getInstance();

        foreach($foldertypeFactory->getFolderTypes(true) as $folderType) {
            $folderClass = $folderType->getFolderHandlerClassname();

            if ($folderClass::ID == $foldertype) {
                $folderClass::addNewFolder($folder);
                /**
                 * @var $folderFactory FolderFactory
                 */
                FolderFactory::clear();
            }
        }


    }

    /**
     * transforms a foldername into its ID. Since the main id is the folder name we need this mapping.
     *
     * @param $foldername
     */
    public function getFolderId($foldername) {
        if (null == $this->_folders) {
            $db = Factory::getDbo();

            $query = $db->getQuery(true);
            $query->select('id, folder')
                ->from('#__eventgallery_folder');

            $db->setQuery($query);
            $results = $db->loadObjectList();

            $this->_folders = array();

            foreach($results as $row) {
                $this->_folders[$row->folder] = $row->id;
            }
        }

        if (isset($this->_folders[$foldername])) {
            return $this->_folders[$foldername];
        }

        return null;

    }

    public static function copyFiles(Folder $sourceFolder, Folder $targetFolder, SymfonyStyle $symphonyStyle = null) {
        $joomlaConfig   = Factory::getApplication()->getConfig();
        foreach($sourceFolder->getFiles() as $file) {
            set_time_limit(30);
            $tempFileName =  tempnam($joomlaConfig->get('tmp_path'), 'eg');

            $download_file = file_get_contents($file->getGoogleImageUrl(COM_EVENTGALLERY_GOOGLE_PHOTOS_IMAGE_SIZE_OF_COPY));

            $handle = fopen($tempFileName, "w");
            fwrite($handle, $download_file);
            fclose($handle);
            $targetFolder->uploadImageFile($tempFileName, $file->getFileName().'.jpg', Factory::getApplication()->getIdentity(), true);

            if ($symphonyStyle) {
                $symphonyStyle->writeln('    Copied '.$file->getFileName());
            }
        }
    }


}
