<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Manager;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Cart;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die();

class OrderManager extends AbstractManager
{

    function __construct()
    {

    }

    /**
     * creates a order from a cart
     *
     * @param Cart $cart
     *
     * @return Order
     */
    public function createOrder($cart)
    {

        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        $order = $orderFactory->createOrder($cart);

        // put the cart in the cart history

        $cart->setStatus(Cart::STATUS_HISTORY);

        return $order;
    }

    /**
     * @param LineitemContainer $lineitemcontainer
     */
    public function processOnOrderSubmit($lineitemcontainer) {

        $lineitemcontainer->getShippingMethod()->processOnOrderSubmit($lineitemcontainer);
        $lineitemcontainer->getPaymentMethod()->processOnOrderSubmit($lineitemcontainer);
        if ($lineitemcontainer->getSurcharge()) {
            $lineitemcontainer->getSurcharge()->processOnOrderSubmit($lineitemcontainer);
        }

    }

    public function getOrders() {
        /* try to get the right user id for the cart. This can also be the session id */
        $session = Factory::getSession();
        $user = Factory::getUser();
        if ($user->guest) {
            $user_id = $session->get(CartManager::EVENTGALLERY_CART_USER_ID);
        } else {
            $user_id = $user->id;
        }

        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        $orders = $orderFactory->getOrdersByUserId($user_id);

        return $orders;

    }

    /**
     * @param string $documentNo
     * @return Order|null
     */
    public function getOrderByDocumentNo($documentNo) {
        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        $order = $orderFactory->getOrdersByDocumentNumber($documentNo);
        return $order;
    }

    /**
     * Returns the order oject for a given ID
     *
     * @param $id
     * @return Order
     */
    public function getOrderById($id) {
        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        $order = $orderFactory->getOrderById($id);
        return $order;
    }


}
