<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Manager;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\SurchargeMethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\SurchargeMethod;

defined('_JEXEC') or die();

class SurchargeManager extends AbstractManager
{
    /**
     * Calculates a method which can be used.
     *
     * @param $cart
     *
     * @return SurchargeMethod|null
     */
    public function calculateSurcharge($cart) {

        /**
         * @var SurchargeMethodFactory $surchargeFactory
         */
        $surchargeFactory = SurchargeMethodFactory::getInstance();
        $methods = $surchargeFactory->getMethods(true);

        foreach($methods as $method) {
            /**
             * @var SurchargeMethod $method
             */
            if ($method->isEligible($cart)) {
                return $method;
            }

        }

        return null;
    }

}
