<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Methods;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;

defined('_JEXEC') or die();

class DummyMethod extends AbstractMethod
{

    protected $_item = null;

    /** @noinspection PhpMissingParentConstructorInspection */
    public function __construct($item) {
        $this->_object = $item;
        $this->_object_id = $item->id;
        $this->_ls_displayname = new Localizablestring($this->_object->displayname);
        $this->_ls_description = new Localizablestring($this->_object->description);
    }

    /**
     * Returns if this method can be used with the current cart.
     *
     * @param LineitemContainer $cart
     *
     * @return bool
     */
    public function isEligible($cart)
    {
        return false;
    }

    protected function _loadMethodData() {

    }

    public function getTypeCode() {

    }

    public function isDoSupportDigital() {

    }
}
