<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Methods;
use ReflectionClass;
use SimpleXMLElement;
use Svenbluege\Component\Eventgallery\Site\Library\Enum\BasketType;
use Svenbluege\Component\Eventgallery\Site\Library\Enum\SupportsDigital;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;
use Svenbluege\Component\Eventgallery\Site\Library\ServiceLineitem;

defined('_JEXEC') or die();

abstract class PaymentMethod extends AbstractMethod
{

    protected $_methodtable = 'Paymentmethod';

    /**
     * Returns if this method can be used with the current cart.
     *
     * @param LineitemContainer $cart
     *
     * @return bool
     */
    public function isEligible($cart)
    {
       $type = $cart->getType();
       $supportDigital = $this->isDoSupportDigital();


       if ($type == BasketType::TYPE_DIGITAL
           && ($supportDigital == SupportsDigital::SUPPORTS_DIGITAL_YES
           || $supportDigital == SupportsDigital::SUPPORTS_DIGITAL_ONLY)) {
           return true;
       }

       if ($type == BasketType::TYPE_PHYSICAL
           && ($supportDigital == SupportsDigital::SUPPORTS_DIGITAL_NO
               || $supportDigital == SupportsDigital::SUPPORTS_DIGITAL_YES)) {
           return true;
       }

       if ($type == BasketType::TYPE_MIXED
           && $supportDigital == SupportsDigital::SUPPORTS_DIGITAL_YES) {
           return true;
       }

       return false;

    }

    /**
     * @see SupportsDigital
     * @return int
     */
    public function isDoSupportDigital() {
        return $this->_object->supportsdigital;
    }

    public function getTypeCode() {
        return ServiceLineitem::TYPE_PAYMENTMETHOD;
    }

    public function doSendMail() {
        return $this->_object->sendmail == 1;
    }

    /**
     * @param $lineitemcontainer LineitemContainer
     * @param $input JInput
     *
     */
    public function processOnPaymentSave($lineitemcontainer, $input) {

    }

    /**
     * Makes sure the payment method is valid while creating the order.
     *
     * @param $lineitemcontainer LineitemContainer
     */
    public function verfiyPaymentMethodServiceLineItem($lineitemcontainer) {
        return true;
    }

    /**
     * @param $lineitemcontainer LineitemContainer
     * @return string
     */

    public function getPaymentPageContentHead($lineitemcontainer) {
        return $this->getDisplayName();
    }

    /**
     * @param $lineitemcontainer LineitemContainer
     * @return string
     */
    public function getPaymentPageContentBody($lineitemcontainer) {
        return $this->getDescription();
    }

    /**
     * Defines if the payment method would like to send a mail if the payment status has changed.
     * This is nothing, the user can change. This is only for this shipping method.
     *
     * @param $lineitemcontainer LineitemContainer
     * @return bool
     */
    public function sendMailOnPaymentStatusChange($lineitemcontainer) {
        if ($lineitemcontainer->getTotal()->getAmount() == 0) {
            return false;
        }
        return true;
    }

    /**
     * Sometimes people want to send order confirmation mails only if the payment is complete. This method will state
     * if we can send an order confirmation mail while creating the order or not.
     *
     * @return boolean
     */
    public function doSendOrderConfirmationMailOnlyOnPaymentComplete() {
        return false;
    }

    public function doRedirectToPaymentProvider() {
        return false;
    }

    public function getRedirectToPaymentProviderUrl($lineitemcontainer) {
        return null;
    }


}
