<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library\Methods;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;
use Svenbluege\Component\Eventgallery\Site\Library\ServiceLineitem;

defined('_JEXEC') or die();

abstract class ShippingMethod extends AbstractMethod
{
    protected $_methodtable = 'Shippingmethod';


    public function getTypeCode() {
        return ServiceLineitem::TYPE_SHIPINGMETHOD;
    }

    /**
     * Defines if the shipping method would like to send a mail if the shipping status has changed.
     *
     * @param $lineitemcontainer LineitemContainer
     * @return bool
     * @since 3.6.6
     */
    public function sendMailOnShippingStatusChange($lineitemcontainer) {
        return true;
    }

    public function doSendMail() {
        return $this->_object->sendmail == 1;
    }

    /**
     * determines if an order can be shipped automatically if it is paid. This is useful for download shipping methods where we actually don't need to do anything.
     *
     * @param $lineitemcontainer
     * @return bool
     * @since 3.6.6
     */
    public function isAutomaticallyShippableIfPaid($lineitemcontainer) {
        return false;
    }

    /**
     * @return boolean
     * @since 3.7.12
     */
    public function needsAddressData() {
        return $this->_object->needsaddressdata == 1;
    }

    /**
     * Returns if this method can be used with the current cart.
     *
     * @param LineitemContainer $cart
     *
     * @return bool
     */
    public function isEligible($cart)
    {
        $type = $cart->getType();
        return in_array($type, $this->getSupportedBasketTypes());
    }

    abstract function getSupportedBasketTypes();
}
