<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library;
use Svenbluege\Component\Eventgallery\Administrator\Table\OrderTable;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderStatusFactory;

defined('_JEXEC') or die();

/**
 * @property mixed cart
 */
class Order extends LineitemContainer
{

    protected $_lineitemstatus = Lineitem::TYPE_CART;
    /**
     * @var OrderTable
     */
    protected $_lineitemcontainer = NULL;
    /**
     * @var string
     */
    protected $_lineitemcontainer_table = "Order";

    protected $_orderstatus = NULL;
    protected $_shippingstatus = NULL;
    protected $_paymentstatus = NULL;

    public function __construct($object)
    {
        if (!is_object($object)) {
            throw new \InvalidArgumentException("Can't initialize Order Object because of missing Data Object.");
        }

        $this->_lineitemcontainer = $object;
        $this->_lineitemcontainer_id = $object->id;

        $this->_loadLineItems();
        $this->_loadServiceLineItems();

        parent::__construct();
    }

    /**
     * @param OrderStatus $orderStatus
     */
    public function setOrderStatus($orderStatus)
    {
        if ($orderStatus == NULL) {
            return;
        }
        $this->_lineitemcontainer->orderstatusid = $orderStatus->getId();
        $this->_storeLineItemContainer();
        $this->_orderstatus = null;
    }

    /**
     * @return OrderStatus
     */
    public function getOrderStatus() {
        if (null==$this->_orderstatus) {
            /**
             * @var OrderStatusFactory $orderstatusFactory
             */
            $orderstatusFactory = OrderStatusFactory::getInstance();
            $this->_orderstatus = $orderstatusFactory->getOrderStatusById($this->_lineitemcontainer->orderstatusid);
        }
        return $this->_orderstatus;
    }

    /**
     * @return OrderStatus
     */
    public function getPaymentStatus() {
        if (null == $this->_paymentstatus) {
            /**
             * @var OrderStatusFactory $orderstatusFactory
             */
            $orderstatusFactory = OrderStatusFactory::getInstance();
            $this->_paymentstatus = $orderstatusFactory->getOrderStatusById($this->_lineitemcontainer->paymentstatusid);
        }
        return $this->_paymentstatus;
    }

    /**
     * @param OrderStatus $paymentstatus
     */
    public function setPaymentStatus($paymentstatus) {
        $this->_lineitemcontainer->paymentstatusid = $paymentstatus->getId();
        $this->_storeLineItemContainer();
        $this->_paymentstatus = null;
    }

    /**
     * @return OrderStatus
     */
    public function getShippingStatus() {
        if (null==$this->_shippingstatus) {
            /**
             * @var OrderStatusFactory $orderstatusFactory
             */
            $orderstatusFactory = OrderStatusFactory::getInstance();
            $this->_shippingstatus = $orderstatusFactory->getOrderStatusById($this->_lineitemcontainer->shippingstatusid);
        }
        return $this->_shippingstatus;
    }

    /**
     * @param OrderStatus $shippingstatus
     */
    public function setShippingStatus($shippingstatus) {
        $this->_lineitemcontainer->shippingstatusid = $shippingstatus->getId();
        $this->_storeLineItemContainer();
        $this->_shippingstatus = null;
    }

    /**
     * returns a token which is necessary to perform downloads for this order
     *
     * @return string
     */
    public function getToken() {
        return $this->_lineitemcontainer->token;
    }

    /**
     * returns the version of this database entry
     *
     * @return int
     */
    public function getVersion() {
        return $this->_lineitemcontainer->version;
    }

    /**
     * returns the language as a String like de-DE, en-GB, en-US
     *
     * @return String
     */
    public function getLanguage() {
        return $this->_lineitemcontainer->language;
    }

    public function isNewsletterOptIn() {
        return $this->_lineitemcontainer->newsletter_optin == 1;
    }
}
