<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Site\Library;
use Svenbluege\Component\Eventgallery\Site\Library\Common\Money;

defined('_JEXEC') or die();

class ScalePrice
{

    /**
     * @var int
     */
    public $quantity;

    /**
     * @var Money()
     */
    public $price;

    /**
     * @param $quantity int
     * @param $price Money()
     */
    public function __construct($quantity, $price) {
        $this->quantity = $quantity;
        $this->price = $price;
    }

    /**
     * @return int
     */
    public function getQuantity() {
        return $this->quantity;
    }

    /**
     * @return Money()
     */
    public function getPrice() {
        return $this->price;
    }

    /**
     * Returns the package price (singleprice * quantity)
     * @return Money()
     */
    public function getPackagePrice() {
        return new Money($this->getPrice()->getAmount() * $this->getQuantity(), $this->getPrice()->getCurrency());
    }

}
